/*
 * Decompiled with CFR 0.152.
 */
package io.seata.tm;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.core.model.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManagerHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionManagerHolder.class);

    public static TransactionManager get() {
        if (SingletonHolder.INSTANCE == null) {
            throw new ShouldNeverHappenException("TransactionManager is NOT ready!");
        }
        return SingletonHolder.INSTANCE;
    }

    public static void set(TransactionManager mock) {
        SingletonHolder.INSTANCE = mock;
    }

    private TransactionManagerHolder() {
    }

    private static class SingletonHolder {
        private static TransactionManager INSTANCE = null;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = (TransactionManager)EnhancedServiceLoader.load(TransactionManager.class);
                LOGGER.info("TransactionManager Singleton {}", (Object)INSTANCE);
            }
            catch (Throwable anyEx) {
                LOGGER.error("Failed to load TransactionManager Singleton! ", anyEx);
            }
        }
    }
}

