/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

class InAppIncludesResolver
implements ApplicationContextAware {
    @Nullable
    private ApplicationContext applicationContext;

    InAppIncludesResolver() {
    }

    @Nullable
    List<String> resolveInAppIncludes() {
        if (this.applicationContext != null) {
            Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(SpringBootConfiguration.class);
            return beansWithAnnotation.values().stream().map(bean -> bean.getClass().getPackage().getName()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

