/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.EventProcessor;
import io.sentry.IpAddressUtils;
import io.sentry.SentryEvent;
import io.sentry.SentryOptions;
import io.sentry.protocol.User;
import io.sentry.spring.SentryUserProvider;
import io.sentry.util.Objects;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryUserProviderEventProcessor
implements EventProcessor {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SentryUserProvider sentryUserProvider;

    public SentryUserProviderEventProcessor(@NotNull SentryOptions options, @NotNull SentryUserProvider sentryUserProvider) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options is required");
        this.sentryUserProvider = (SentryUserProvider)Objects.requireNonNull((Object)sentryUserProvider, (String)"sentryUserProvider is required");
    }

    public SentryEvent process(@NotNull SentryEvent event, @Nullable Object hint) {
        User existingUser;
        User user = this.sentryUserProvider.provideUser();
        if (user != null) {
            existingUser = Optional.ofNullable(event.getUser()).orElseGet(User::new);
            Optional.ofNullable(user.getEmail()).ifPresent(arg_0 -> ((User)existingUser).setEmail(arg_0));
            Optional.ofNullable(user.getId()).ifPresent(arg_0 -> ((User)existingUser).setId(arg_0));
            Optional.ofNullable(user.getIpAddress()).ifPresent(arg_0 -> ((User)existingUser).setIpAddress(arg_0));
            Optional.ofNullable(user.getUsername()).ifPresent(arg_0 -> ((User)existingUser).setUsername(arg_0));
            if (user.getOthers() != null && !user.getOthers().isEmpty()) {
                if (existingUser.getOthers() == null) {
                    existingUser.setOthers(new ConcurrentHashMap());
                }
                for (Map.Entry entry : user.getOthers().entrySet()) {
                    existingUser.getOthers().put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            event.setUser(existingUser);
        }
        if (this.options.isSendDefaultPii() && (existingUser = event.getUser()) != null && IpAddressUtils.isDefault((String)existingUser.getIpAddress())) {
            existingUser.setIpAddress(null);
        }
        return event;
    }

    @NotNull
    @ApiStatus.Internal
    public SentryUserProvider getSentryUserProvider() {
        return this.sentryUserProvider;
    }
}

