/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.IHub;
import io.sentry.Sentry;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.task.TaskDecorator;

public final class SentryTaskDecorator
implements TaskDecorator {
    @NotNull
    public Runnable decorate(@NotNull Runnable runnable) {
        IHub newHub = Sentry.getCurrentHub().clone();
        return () -> {
            IHub oldState = Sentry.getCurrentHub();
            Sentry.setCurrentHub((IHub)newHub);
            try {
                runnable.run();
            }
            finally {
                Sentry.setCurrentHub((IHub)oldState);
            }
        };
    }
}

