/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import io.shardingjdbc.core.api.algorithm.sharding.ListShardingValue;
import io.shardingjdbc.core.api.algorithm.sharding.RangeShardingValue;
import io.shardingjdbc.core.api.algorithm.sharding.ShardingValue;
import io.shardingjdbc.core.constant.ShardingOperator;
import io.shardingjdbc.core.hint.HintManagerHolder;
import io.shardingjdbc.core.hint.ShardingKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class HintManager
implements AutoCloseable {
    private final Map<ShardingKey, ShardingValue> databaseShardingValues = new HashMap<ShardingKey, ShardingValue>();
    private final Map<ShardingKey, ShardingValue> tableShardingValues = new HashMap<ShardingKey, ShardingValue>();
    private boolean shardingHint;
    private boolean masterRouteOnly;
    private boolean databaseShardingOnly;

    public static HintManager getInstance() {
        HintManager result = new HintManager();
        HintManagerHolder.setHintManager(result);
        return result;
    }

    public void setDatabaseShardingValue(Comparable<?> value) {
        this.databaseShardingOnly = true;
        this.addDatabaseShardingValue("DB_TABLE_NAME", "DB_COLUMN_NAME", value);
    }

    public void addDatabaseShardingValue(String logicTable, String shardingColumn, Comparable<?> value) {
        this.addDatabaseShardingValue(logicTable, shardingColumn, ShardingOperator.EQUAL, value);
    }

    public void addDatabaseShardingValue(String logicTable, String shardingColumn, ShardingOperator operator, Comparable<?> ... values) {
        this.shardingHint = true;
        this.databaseShardingValues.put(new ShardingKey(logicTable, shardingColumn), this.getShardingValue(logicTable, shardingColumn, operator, values));
    }

    public void addTableShardingValue(String logicTable, String shardingColumn, Comparable<?> value) {
        this.addTableShardingValue(logicTable, shardingColumn, ShardingOperator.EQUAL, value);
    }

    public void addTableShardingValue(String logicTable, String shardingColumn, ShardingOperator operator, Comparable<?> ... values) {
        this.shardingHint = true;
        this.tableShardingValues.put(new ShardingKey(logicTable, shardingColumn), this.getShardingValue(logicTable, shardingColumn, operator, values));
    }

    private ShardingValue getShardingValue(String logicTable, String shardingColumn, ShardingOperator operator, Comparable<?>[] values) {
        Preconditions.checkArgument((null != values && values.length > 0 ? 1 : 0) != 0);
        switch (operator) {
            case EQUAL: 
            case IN: {
                return new ListShardingValue(logicTable, shardingColumn, Arrays.asList(values));
            }
            case BETWEEN: {
                return new RangeShardingValue(logicTable, shardingColumn, Range.range(values[0], (BoundType)BoundType.CLOSED, values[1], (BoundType)BoundType.CLOSED));
            }
        }
        throw new UnsupportedOperationException(operator.getExpression());
    }

    public ShardingValue getDatabaseShardingValue(ShardingKey shardingKey) {
        return this.databaseShardingValues.get(shardingKey);
    }

    public ShardingValue getTableShardingValue(ShardingKey shardingKey) {
        return this.tableShardingValues.get(shardingKey);
    }

    public void setMasterRouteOnly() {
        this.masterRouteOnly = true;
    }

    @Override
    public void close() {
        HintManagerHolder.clear();
    }

    private HintManager() {
    }

    public boolean isShardingHint() {
        return this.shardingHint;
    }

    public boolean isMasterRouteOnly() {
        return this.masterRouteOnly;
    }

    public boolean isDatabaseShardingOnly() {
        return this.databaseShardingOnly;
    }
}

