/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.api.config.strategy;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.algorithm.sharding.hint.HintShardingAlgorithm;
import io.shardingjdbc.core.api.config.strategy.ShardingStrategyConfiguration;
import io.shardingjdbc.core.routing.strategy.ShardingAlgorithmFactory;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import io.shardingjdbc.core.routing.strategy.hint.HintShardingStrategy;
import java.beans.ConstructorProperties;

public final class HintShardingStrategyConfiguration
implements ShardingStrategyConfiguration {
    private final String algorithmClassName;

    @Override
    public ShardingStrategy build() {
        Preconditions.checkNotNull((Object)this.algorithmClassName, (Object)"Algorithm class cannot be null.");
        return new HintShardingStrategy(ShardingAlgorithmFactory.newInstance(this.algorithmClassName, HintShardingAlgorithm.class));
    }

    @ConstructorProperties(value={"algorithmClassName"})
    public HintShardingStrategyConfiguration(String algorithmClassName) {
        this.algorithmClassName = algorithmClassName;
    }

    public String getAlgorithmClassName() {
        return this.algorithmClassName;
    }
}

