/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.merger.groupby;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.shardingjdbc.core.merger.groupby.GroupByValue;
import io.shardingjdbc.core.merger.groupby.aggregation.AggregationUnit;
import io.shardingjdbc.core.merger.groupby.aggregation.AggregationUnitFactory;
import io.shardingjdbc.core.merger.orderby.OrderByStreamResultSetMerger;
import io.shardingjdbc.core.parsing.parser.context.selectitem.AggregationSelectItem;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class GroupByStreamResultSetMerger
extends OrderByStreamResultSetMerger {
    private final Map<String, Integer> labelAndIndexMap;
    private final SelectStatement selectStatement;
    private final List<Object> currentRow;
    private List<?> currentGroupByValues;

    public GroupByStreamResultSetMerger(Map<String, Integer> labelAndIndexMap, List<ResultSet> resultSets, SelectStatement selectStatement) throws SQLException {
        super(resultSets, selectStatement.getOrderByItems());
        this.labelAndIndexMap = labelAndIndexMap;
        this.selectStatement = selectStatement;
        this.currentRow = new ArrayList<Object>(labelAndIndexMap.size());
        this.currentGroupByValues = this.getOrderByValuesQueue().isEmpty() ? Collections.emptyList() : new GroupByValue(this.getCurrentResultSet(), selectStatement.getGroupByItems()).getGroupValues();
    }

    @Override
    public boolean next() throws SQLException {
        this.currentRow.clear();
        if (this.getOrderByValuesQueue().isEmpty()) {
            return false;
        }
        if (this.isFirstNext()) {
            super.next();
        }
        if (this.aggregateCurrentGroupByRowAndNext()) {
            this.currentGroupByValues = new GroupByValue(this.getCurrentResultSet(), this.selectStatement.getGroupByItems()).getGroupValues();
        }
        return true;
    }

    private boolean aggregateCurrentGroupByRowAndNext() throws SQLException {
        boolean result = false;
        ImmutableMap aggregationUnitMap = Maps.toMap(this.selectStatement.getAggregationSelectItems(), (Function)new Function<AggregationSelectItem, AggregationUnit>(){

            public AggregationUnit apply(AggregationSelectItem input) {
                return AggregationUnitFactory.create(input.getType());
            }
        });
        while (this.currentGroupByValues.equals(new GroupByValue(this.getCurrentResultSet(), this.selectStatement.getGroupByItems()).getGroupValues())) {
            this.aggregate((Map<AggregationSelectItem, AggregationUnit>)aggregationUnitMap);
            this.cacheCurrentRow();
            result = super.next();
            if (result) continue;
        }
        this.setAggregationValueToCurrentRow((Map<AggregationSelectItem, AggregationUnit>)aggregationUnitMap);
        return result;
    }

    private void aggregate(Map<AggregationSelectItem, AggregationUnit> aggregationUnitMap) throws SQLException {
        for (Map.Entry<AggregationSelectItem, AggregationUnit> entry : aggregationUnitMap.entrySet()) {
            ArrayList values = new ArrayList(2);
            if (entry.getKey().getDerivedAggregationSelectItems().isEmpty()) {
                values.add(this.getAggregationValue(entry.getKey()));
            } else {
                for (AggregationSelectItem each : entry.getKey().getDerivedAggregationSelectItems()) {
                    values.add(this.getAggregationValue(each));
                }
            }
            entry.getValue().merge(values);
        }
    }

    private void cacheCurrentRow() throws SQLException {
        for (int i = 0; i < this.getCurrentResultSet().getMetaData().getColumnCount(); ++i) {
            this.currentRow.add(this.getCurrentResultSet().getObject(i + 1));
        }
    }

    private Comparable<?> getAggregationValue(AggregationSelectItem aggregationSelectItem) throws SQLException {
        Object result = this.getCurrentResultSet().getObject(aggregationSelectItem.getIndex());
        Preconditions.checkState((null == result || result instanceof Comparable ? 1 : 0) != 0, (Object)"Aggregation value must implements Comparable");
        return (Comparable)result;
    }

    private void setAggregationValueToCurrentRow(Map<AggregationSelectItem, AggregationUnit> aggregationUnitMap) {
        for (Map.Entry<AggregationSelectItem, AggregationUnit> entry : aggregationUnitMap.entrySet()) {
            this.currentRow.set(entry.getKey().getIndex() - 1, entry.getValue().getResult());
        }
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        return this.currentRow.get(columnIndex - 1);
    }

    @Override
    public Object getValue(String columnLabel, Class<?> type) throws SQLException {
        Preconditions.checkState((boolean)this.labelAndIndexMap.containsKey(columnLabel), (Object)String.format("Can't find columnLabel: %s", columnLabel));
        return this.currentRow.get(this.labelAndIndexMap.get(columnLabel) - 1);
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        return this.currentRow.get(columnIndex - 1);
    }

    @Override
    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) throws SQLException {
        Preconditions.checkState((boolean)this.labelAndIndexMap.containsKey(columnLabel), (Object)String.format("Can't find columnLabel: %s", columnLabel));
        return this.currentRow.get(this.labelAndIndexMap.get(columnLabel) - 1);
    }
}

