/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.clause;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.Assist;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Keyword;
import io.shardingjdbc.core.parsing.lexer.token.Literals;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.SQLClauseParser;
import io.shardingjdbc.core.parsing.parser.context.condition.Column;
import io.shardingjdbc.core.parsing.parser.context.condition.Condition;
import io.shardingjdbc.core.parsing.parser.expression.SQLExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLIgnoreExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLPlaceholderExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLTextExpression;
import io.shardingjdbc.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.util.SQLUtil;
import java.beans.ConstructorProperties;

public class InsertSetClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;

    public void parse(InsertStatement insertStatement) {
        if (!this.lexerEngine.skipIfEqual(this.getCustomizedInsertKeywords())) {
            return;
        }
        do {
            SQLExpression sqlExpression;
            Column column = new Column(SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals()), insertStatement.getTables().getSingleTableName());
            this.lexerEngine.nextToken();
            this.lexerEngine.accept(Symbol.EQ);
            if (this.lexerEngine.equalAny(Literals.INT)) {
                sqlExpression = new SQLNumberExpression(Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals()));
            } else if (this.lexerEngine.equalAny(Literals.FLOAT)) {
                sqlExpression = new SQLNumberExpression(Double.parseDouble(this.lexerEngine.getCurrentToken().getLiterals()));
            } else if (this.lexerEngine.equalAny(Literals.CHARS)) {
                sqlExpression = new SQLTextExpression(this.lexerEngine.getCurrentToken().getLiterals());
            } else if (this.lexerEngine.equalAny(DefaultKeyword.NULL)) {
                sqlExpression = new SQLIgnoreExpression(DefaultKeyword.NULL.name());
            } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
                sqlExpression = new SQLPlaceholderExpression(insertStatement.getParametersIndex());
                insertStatement.increaseParametersIndex();
            } else {
                throw new UnsupportedOperationException("");
            }
            this.lexerEngine.nextToken();
            if (this.lexerEngine.equalAny(Symbol.COMMA, DefaultKeyword.ON, Assist.END)) {
                insertStatement.getConditions().add(new Condition(column, sqlExpression), this.shardingRule);
                continue;
            }
            this.lexerEngine.skipUntil(Symbol.COMMA, DefaultKeyword.ON);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    protected Keyword[] getCustomizedInsertKeywords() {
        return new Keyword[0];
    }

    @ConstructorProperties(value={"shardingRule", "lexerEngine"})
    public InsertSetClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
    }
}

