/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql.ddl.create;

import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.parser.dialect.mysql.sql.MySQLCreateParser;
import io.shardingjdbc.core.parsing.parser.dialect.oracle.sql.OracleCreateParser;
import io.shardingjdbc.core.parsing.parser.dialect.postgresql.sql.PostgreSQLCreateParser;
import io.shardingjdbc.core.parsing.parser.dialect.sqlserver.sql.SQLServerCreateParser;
import io.shardingjdbc.core.parsing.parser.sql.ddl.create.AbstractCreateParser;
import io.shardingjdbc.core.rule.ShardingRule;

public final class CreateParserFactory {
    public static AbstractCreateParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLCreateParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleCreateParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerCreateParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLCreateParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private CreateParserFactory() {
    }
}

