/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql.ddl.drop;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Keyword;
import io.shardingjdbc.core.parsing.lexer.token.Token;
import io.shardingjdbc.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingjdbc.core.parsing.parser.exception.SQLParsingException;
import io.shardingjdbc.core.parsing.parser.sql.SQLParser;
import io.shardingjdbc.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingjdbc.core.parsing.parser.token.IndexToken;
import io.shardingjdbc.core.rule.ShardingRule;

public abstract class AbstractDropParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public AbstractDropParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public DDLStatement parse() {
        this.lexerEngine.nextToken();
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenDropAndTable());
        DDLStatement result = new DDLStatement();
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.INDEX)) {
            this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenDropIndexAndIndexName());
            this.parseIndex(result);
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.TABLE)) {
            this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenDropTableAndTableName());
            this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        } else {
            throw new SQLParsingException("Can't support other DROP grammar unless DROP TABLE, DROP INDEX.", new Object[0]);
        }
        return result;
    }

    protected Keyword[] getSkippedKeywordsBetweenDropAndTable() {
        return new Keyword[0];
    }

    protected Keyword[] getSkippedKeywordsBetweenDropIndexAndIndexName() {
        return new Keyword[0];
    }

    private void parseIndex(DDLStatement ddlStatement) {
        Token currentToken = this.lexerEngine.getCurrentToken();
        int beginPosition = currentToken.getEndPosition() - currentToken.getLiterals().length();
        String literals = currentToken.getLiterals();
        this.lexerEngine.skipUntil(DefaultKeyword.ON);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.ON)) {
            this.tableReferencesClauseParser.parseSingleTableWithoutAlias(ddlStatement);
            ddlStatement.getSqlTokens().add(new IndexToken(beginPosition, literals, ddlStatement.getTables().getSingleTableName()));
        } else {
            ddlStatement.getSqlTokens().add(new IndexToken(beginPosition, literals, ""));
        }
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenDropTableAndTableName();

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    protected TableReferencesClauseParser getTableReferencesClauseParser() {
        return this.tableReferencesClauseParser;
    }
}

