/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.rewrite;

import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SQLBuilder {
    private final List<Object> segments;
    private StringBuilder currentSegment;

    public SQLBuilder() {
        this.segments = new LinkedList<Object>();
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    public void appendLiterals(String literals) {
        this.currentSegment.append(literals);
    }

    public void appendIndex(String indexName, String tableName) {
        this.segments.add(new IndexToken(indexName, tableName));
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    public void appendTable(String tableName) {
        this.segments.add(new TableToken(tableName));
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    public String toSQL(Map<String, String> tableTokens) {
        StringBuilder result = new StringBuilder();
        for (Object each : this.segments) {
            if (each instanceof TableToken && tableTokens.containsKey(((TableToken)each).tableName)) {
                result.append(tableTokens.get(((TableToken)each).tableName));
                continue;
            }
            if (each instanceof IndexToken) {
                IndexToken indexToken = (IndexToken)each;
                result.append(indexToken.indexName);
                String tableName = tableTokens.get(indexToken.tableName);
                if (Strings.isNullOrEmpty((String)tableName)) continue;
                result.append("_");
                result.append(tableName);
                continue;
            }
            result.append(each);
        }
        return result.toString();
    }

    private SQLBuilder(List<Object> segments) {
        this.segments = segments;
    }

    private class IndexToken {
        private final String indexName;
        private final String tableName;

        public String toString() {
            return this.indexName;
        }

        @ConstructorProperties(value={"indexName", "tableName"})
        public IndexToken(String indexName, String tableName) {
            this.indexName = indexName;
            this.tableName = tableName;
        }
    }

    private class TableToken {
        private final String tableName;

        public String toString() {
            return this.tableName;
        }

        @ConstructorProperties(value={"tableName"})
        public TableToken(String tableName) {
            this.tableName = tableName;
        }
    }
}

