/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.strategy.complex;

import io.shardingjdbc.core.api.algorithm.sharding.ShardingValue;
import io.shardingjdbc.core.api.algorithm.sharding.complex.ComplexKeysShardingAlgorithm;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import java.util.Collection;
import java.util.TreeSet;

public final class ComplexShardingStrategy
implements ShardingStrategy {
    private final Collection<String> shardingColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final ComplexKeysShardingAlgorithm shardingAlgorithm;

    public ComplexShardingStrategy(Collection<String> shardingColumns, ComplexKeysShardingAlgorithm shardingAlgorithm) {
        this.shardingColumns.addAll(shardingColumns);
        this.shardingAlgorithm = shardingAlgorithm;
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<ShardingValue> shardingValues) {
        Collection<String> shardingResult = this.shardingAlgorithm.doSharding(availableTargetNames, shardingValues);
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    @Override
    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }
}

