/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.rule;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.shardingjdbc.core.api.config.TableRuleConfiguration;
import io.shardingjdbc.core.api.config.strategy.NoneShardingStrategyConfiguration;
import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.core.keygen.KeyGenerator;
import io.shardingjdbc.core.parsing.parser.context.condition.Column;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import io.shardingjdbc.core.routing.strategy.none.NoneShardingStrategy;
import io.shardingjdbc.core.rule.BindingTableRule;
import io.shardingjdbc.core.rule.TableRule;
import io.shardingjdbc.core.util.StringUtil;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.sql.DataSource;

public final class ShardingRule {
    private final Map<String, DataSource> dataSourceMap;
    private final String defaultDataSourceName;
    private final Collection<TableRule> tableRules;
    private final Collection<BindingTableRule> bindingTableRules = new LinkedList<BindingTableRule>();
    private final ShardingStrategy defaultDatabaseShardingStrategy;
    private final ShardingStrategy defaultTableShardingStrategy;
    private final KeyGenerator defaultKeyGenerator;

    public ShardingRule(Map<String, DataSource> dataSourceMap, String defaultDataSourceName, Collection<TableRule> tableRules, Collection<String> bindingTableGroups, ShardingStrategy defaultDatabaseShardingStrategy, ShardingStrategy defaultTableShardingStrategy, KeyGenerator defaultKeyGenerator) {
        this.dataSourceMap = dataSourceMap;
        this.defaultDataSourceName = this.getDefaultDataSourceName(dataSourceMap, defaultDataSourceName);
        this.tableRules = tableRules;
        for (String group : bindingTableGroups) {
            LinkedList<TableRule> tableRulesForBinding = new LinkedList<TableRule>();
            for (String logicTableNameForBindingTable : StringUtil.splitWithComma(group)) {
                tableRulesForBinding.add(this.getTableRule(logicTableNameForBindingTable));
            }
            this.bindingTableRules.add(new BindingTableRule(tableRulesForBinding));
        }
        this.defaultDatabaseShardingStrategy = null == defaultDatabaseShardingStrategy ? new NoneShardingStrategy() : defaultDatabaseShardingStrategy;
        this.defaultTableShardingStrategy = null == defaultTableShardingStrategy ? new NoneShardingStrategy() : defaultTableShardingStrategy;
        this.defaultKeyGenerator = defaultKeyGenerator;
    }

    private String getDefaultDataSourceName(Map<String, DataSource> dataSourceMap, String defaultDataSourceName) {
        if (1 == dataSourceMap.size()) {
            return dataSourceMap.entrySet().iterator().next().getKey();
        }
        if (Strings.isNullOrEmpty((String)defaultDataSourceName)) {
            return null;
        }
        return defaultDataSourceName;
    }

    public Optional<TableRule> tryFindTableRule(String logicTableName) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equals(logicTableName.toLowerCase())) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public TableRule getTableRule(String logicTableName) {
        Optional<TableRule> tableRule = this.tryFindTableRule(logicTableName.toLowerCase());
        if (tableRule.isPresent()) {
            return (TableRule)tableRule.get();
        }
        if (null != this.defaultDataSourceName) {
            return this.createTableRuleWithDefaultDataSource(logicTableName.toLowerCase());
        }
        throw new ShardingJdbcException("Cannot find table rule and default data source with logic table: '%s'", logicTableName);
    }

    private TableRule createTableRuleWithDefaultDataSource(String logicTableName) {
        HashMap<String, DataSource> defaultDataSourceMap = new HashMap<String, DataSource>(1, 1.0f);
        defaultDataSourceMap.put(this.defaultDataSourceName, this.dataSourceMap.get(this.defaultDataSourceName));
        TableRuleConfiguration config = new TableRuleConfiguration();
        config.setLogicTable(logicTableName);
        config.setDatabaseShardingStrategyConfig(new NoneShardingStrategyConfiguration());
        config.setTableShardingStrategyConfig(new NoneShardingStrategyConfiguration());
        return new TableRule(logicTableName, null, defaultDataSourceMap, null, null, null, null, null);
    }

    public ShardingStrategy getDatabaseShardingStrategy(TableRule tableRule) {
        return null == tableRule.getDatabaseShardingStrategy() ? this.defaultDatabaseShardingStrategy : tableRule.getDatabaseShardingStrategy();
    }

    public ShardingStrategy getTableShardingStrategy(TableRule tableRule) {
        return null == tableRule.getTableShardingStrategy() ? this.defaultTableShardingStrategy : tableRule.getTableShardingStrategy();
    }

    public boolean isAllBindingTables(Collection<String> logicTables) {
        if (logicTables.isEmpty()) {
            return false;
        }
        Optional<BindingTableRule> bindingTableRule = this.findBindingTableRule(logicTables);
        if (!bindingTableRule.isPresent()) {
            return false;
        }
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(((BindingTableRule)bindingTableRule.get()).getAllLogicTables());
        return !result.isEmpty() && result.containsAll(logicTables);
    }

    public boolean isAllInDefaultDataSource(Collection<String> logicTables) {
        for (String each : logicTables) {
            if (!this.tryFindTableRule(each).isPresent()) continue;
            return false;
        }
        return !logicTables.isEmpty();
    }

    private Optional<BindingTableRule> findBindingTableRule(Collection<String> logicTables) {
        for (String each : logicTables) {
            Optional<BindingTableRule> result = this.findBindingTableRule(each);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.absent();
    }

    public Optional<BindingTableRule> findBindingTableRule(String logicTable) {
        for (BindingTableRule each : this.bindingTableRules) {
            if (!each.hasLogicTable(logicTable)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public boolean isShardingColumn(Column column) {
        if (this.defaultDatabaseShardingStrategy.getShardingColumns().contains(column.getName()) || this.defaultTableShardingStrategy.getShardingColumns().contains(column.getName())) {
            return true;
        }
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equalsIgnoreCase(column.getTableName())) continue;
            if (null != each.getDatabaseShardingStrategy() && each.getDatabaseShardingStrategy().getShardingColumns().contains(column.getName())) {
                return true;
            }
            if (null == each.getTableShardingStrategy() || !each.getTableShardingStrategy().getShardingColumns().contains(column.getName())) continue;
            return true;
        }
        return false;
    }

    public Optional<String> getGenerateKeyColumn(String logicTableName) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equalsIgnoreCase(logicTableName)) continue;
            return Optional.fromNullable((Object)each.getGenerateKeyColumn());
        }
        return Optional.absent();
    }

    public Number generateKey(String logicTableName) {
        Optional<TableRule> tableRule = this.tryFindTableRule(logicTableName);
        if (!tableRule.isPresent()) {
            throw new ShardingJdbcException("Cannot find strategy for generate keys.", new Object[0]);
        }
        if (null != ((TableRule)tableRule.get()).getKeyGenerator()) {
            return ((TableRule)tableRule.get()).getKeyGenerator().generateKey();
        }
        return this.defaultKeyGenerator.generateKey();
    }

    public String getLogicTableName(String logicIndexName) {
        for (TableRule each : this.tableRules) {
            if (!logicIndexName.equals(each.getLogicIndex())) continue;
            return each.getLogicTable();
        }
        throw new ShardingJdbcException("Cannot find logic table name with logic index name: '%s'", logicIndexName);
    }

    @ConstructorProperties(value={"dataSourceMap", "defaultDataSourceName", "tableRules", "defaultDatabaseShardingStrategy", "defaultTableShardingStrategy", "defaultKeyGenerator"})
    public ShardingRule(Map<String, DataSource> dataSourceMap, String defaultDataSourceName, Collection<TableRule> tableRules, ShardingStrategy defaultDatabaseShardingStrategy, ShardingStrategy defaultTableShardingStrategy, KeyGenerator defaultKeyGenerator) {
        this.dataSourceMap = dataSourceMap;
        this.defaultDataSourceName = defaultDataSourceName;
        this.tableRules = tableRules;
        this.defaultDatabaseShardingStrategy = defaultDatabaseShardingStrategy;
        this.defaultTableShardingStrategy = defaultTableShardingStrategy;
        this.defaultKeyGenerator = defaultKeyGenerator;
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    public Collection<TableRule> getTableRules() {
        return this.tableRules;
    }

    public Collection<BindingTableRule> getBindingTableRules() {
        return this.bindingTableRules;
    }

    public ShardingStrategy getDefaultDatabaseShardingStrategy() {
        return this.defaultDatabaseShardingStrategy;
    }

    public ShardingStrategy getDefaultTableShardingStrategy() {
        return this.defaultTableShardingStrategy;
    }

    public KeyGenerator getDefaultKeyGenerator() {
        return this.defaultKeyGenerator;
    }
}

