/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.yaml.sharding;

import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.api.config.ShardingRuleConfiguration;
import io.shardingjdbc.core.yaml.masterslave.YamlMasterSlaveRuleConfiguration;
import io.shardingjdbc.core.yaml.sharding.YamlShardingStrategyConfiguration;
import io.shardingjdbc.core.yaml.sharding.YamlTableRuleConfiguration;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class YamlShardingRuleConfiguration {
    private String defaultDataSourceName;
    private Map<String, YamlTableRuleConfiguration> tables = new HashMap<String, YamlTableRuleConfiguration>();
    private List<String> bindingTables = new ArrayList<String>();
    private YamlShardingStrategyConfiguration defaultDatabaseStrategy;
    private YamlShardingStrategyConfiguration defaultTableStrategy;
    private String defaultKeyGeneratorClass;
    private Map<String, YamlMasterSlaveRuleConfiguration> masterSlaveRules = new HashMap<String, YamlMasterSlaveRuleConfiguration>();
    private Map<String, Object> configMap = new ConcurrentHashMap<String, Object>();
    private Properties props = new Properties();

    public ShardingRuleConfiguration getShardingRuleConfiguration() throws SQLException {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        result.setDefaultDataSourceName(this.defaultDataSourceName);
        for (Map.Entry<String, YamlTableRuleConfiguration> entry : this.tables.entrySet()) {
            YamlTableRuleConfiguration tableRuleConfig = entry.getValue();
            tableRuleConfig.setLogicTable(entry.getKey());
            result.getTableRuleConfigs().add(tableRuleConfig.build());
        }
        result.getBindingTableGroups().addAll(this.bindingTables);
        if (null != this.defaultDatabaseStrategy) {
            result.setDefaultDatabaseShardingStrategyConfig(this.defaultDatabaseStrategy.build());
        }
        if (null != this.defaultTableStrategy) {
            result.setDefaultTableShardingStrategyConfig(this.defaultTableStrategy.build());
        }
        result.setDefaultKeyGeneratorClass(this.defaultKeyGeneratorClass);
        LinkedList<MasterSlaveRuleConfiguration> masterSlaveRuleConfigs = new LinkedList<MasterSlaveRuleConfiguration>();
        for (Map.Entry<String, YamlMasterSlaveRuleConfiguration> each : this.masterSlaveRules.entrySet()) {
            MasterSlaveRuleConfiguration msRuleConfig = new MasterSlaveRuleConfiguration();
            msRuleConfig.setName(each.getKey());
            msRuleConfig.setMasterDataSourceName(each.getValue().getMasterDataSourceName());
            msRuleConfig.setSlaveDataSourceNames(each.getValue().getSlaveDataSourceNames());
            msRuleConfig.setLoadBalanceAlgorithmType(each.getValue().getLoadBalanceAlgorithmType());
            msRuleConfig.setLoadBalanceAlgorithmClassName(each.getValue().getLoadBalanceAlgorithmClassName());
            masterSlaveRuleConfigs.add(msRuleConfig);
        }
        result.setMasterSlaveRuleConfigs(masterSlaveRuleConfigs);
        return result;
    }

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    public Map<String, YamlTableRuleConfiguration> getTables() {
        return this.tables;
    }

    public List<String> getBindingTables() {
        return this.bindingTables;
    }

    public YamlShardingStrategyConfiguration getDefaultDatabaseStrategy() {
        return this.defaultDatabaseStrategy;
    }

    public YamlShardingStrategyConfiguration getDefaultTableStrategy() {
        return this.defaultTableStrategy;
    }

    public String getDefaultKeyGeneratorClass() {
        return this.defaultKeyGeneratorClass;
    }

    public Map<String, YamlMasterSlaveRuleConfiguration> getMasterSlaveRules() {
        return this.masterSlaveRules;
    }

    public Map<String, Object> getConfigMap() {
        return this.configMap;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setDefaultDataSourceName(String defaultDataSourceName) {
        this.defaultDataSourceName = defaultDataSourceName;
    }

    public void setTables(Map<String, YamlTableRuleConfiguration> tables) {
        this.tables = tables;
    }

    public void setBindingTables(List<String> bindingTables) {
        this.bindingTables = bindingTables;
    }

    public void setDefaultDatabaseStrategy(YamlShardingStrategyConfiguration defaultDatabaseStrategy) {
        this.defaultDatabaseStrategy = defaultDatabaseStrategy;
    }

    public void setDefaultTableStrategy(YamlShardingStrategyConfiguration defaultTableStrategy) {
        this.defaultTableStrategy = defaultTableStrategy;
    }

    public void setDefaultKeyGeneratorClass(String defaultKeyGeneratorClass) {
        this.defaultKeyGeneratorClass = defaultKeyGeneratorClass;
    }

    public void setMasterSlaveRules(Map<String, YamlMasterSlaveRuleConfiguration> masterSlaveRules) {
        this.masterSlaveRules = masterSlaveRules;
    }

    public void setConfigMap(Map<String, Object> configMap) {
        this.configMap = configMap;
    }

    public void setProps(Properties props) {
        this.props = props;
    }
}

