/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.shardingsphere.core.hint.HintManagerHolder;

public final class HintManager
implements AutoCloseable {
    private final Multimap<String, Comparable<?>> databaseShardingValues = HashMultimap.create();
    private final Multimap<String, Comparable<?>> tableShardingValues = HashMultimap.create();
    private boolean databaseShardingOnly;
    private boolean masterRouteOnly;

    public static HintManager getInstance() {
        HintManager result = new HintManager();
        HintManagerHolder.setHintManager(result);
        return result;
    }

    public void setDatabaseShardingValue(Comparable<?> value) {
        this.databaseShardingValues.clear();
        this.addDatabaseShardingValue("DB_TABLE_NAME", value);
        this.databaseShardingOnly = true;
    }

    public void setMasterRouteOnly() {
        this.masterRouteOnly = true;
    }

    public void addDatabaseShardingValue(String logicTable, Comparable<?> value) {
        this.databaseShardingValues.put((Object)logicTable, value);
        this.databaseShardingOnly = false;
    }

    public void addTableShardingValue(String logicTable, Comparable<?> value) {
        this.tableShardingValues.put((Object)logicTable, value);
        this.databaseShardingOnly = false;
    }

    @Override
    public void close() {
        HintManagerHolder.clear();
    }

    private HintManager() {
    }

    public Multimap<String, Comparable<?>> getDatabaseShardingValues() {
        return this.databaseShardingValues;
    }

    public Multimap<String, Comparable<?>> getTableShardingValues() {
        return this.tableShardingValues;
    }

    public boolean isDatabaseShardingOnly() {
        return this.databaseShardingOnly;
    }

    public boolean isMasterRouteOnly() {
        return this.masterRouteOnly;
    }
}

