/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dql.groupby;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.merger.dql.common.MemoryMergedResult;
import io.shardingsphere.core.merger.dql.common.MemoryQueryResultRow;
import io.shardingsphere.core.merger.dql.groupby.GroupByRowComparator;
import io.shardingsphere.core.merger.dql.groupby.GroupByValue;
import io.shardingsphere.core.merger.dql.groupby.aggregation.AggregationUnit;
import io.shardingsphere.core.merger.dql.groupby.aggregation.AggregationUnitFactory;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationSelectItem;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class GroupByMemoryMergedResult
extends MemoryMergedResult {
    private final SelectStatement selectStatement;
    private final Iterator<MemoryQueryResultRow> memoryResultSetRows;

    public GroupByMemoryMergedResult(Map<String, Integer> labelAndIndexMap, List<QueryResult> queryResults, SelectStatement selectStatement) throws SQLException {
        super(labelAndIndexMap);
        this.selectStatement = selectStatement;
        this.memoryResultSetRows = this.init(queryResults);
    }

    private Iterator<MemoryQueryResultRow> init(List<QueryResult> queryResults) throws SQLException {
        HashMap<GroupByValue, MemoryQueryResultRow> dataMap = new HashMap<GroupByValue, MemoryQueryResultRow>(1024);
        HashMap<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap = new HashMap<GroupByValue, Map<AggregationSelectItem, AggregationUnit>>(1024);
        for (QueryResult each : queryResults) {
            while (each.next()) {
                GroupByValue groupByValue = new GroupByValue(each, this.selectStatement.getGroupByItems());
                this.initForFirstGroupByValue(each, groupByValue, dataMap, aggregationMap);
                this.aggregate(each, groupByValue, aggregationMap);
            }
        }
        this.setAggregationValueToMemoryRow(dataMap, aggregationMap);
        List<MemoryQueryResultRow> result = this.getMemoryResultSetRows(dataMap);
        if (!result.isEmpty()) {
            this.setCurrentResultSetRow(result.get(0));
        }
        return result.iterator();
    }

    private void initForFirstGroupByValue(QueryResult queryResult, GroupByValue groupByValue, Map<GroupByValue, MemoryQueryResultRow> dataMap, Map<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap) throws SQLException {
        if (!dataMap.containsKey(groupByValue)) {
            dataMap.put(groupByValue, new MemoryQueryResultRow(queryResult));
        }
        if (!aggregationMap.containsKey(groupByValue)) {
            ImmutableMap map = Maps.toMap(this.selectStatement.getAggregationSelectItems(), (Function)new Function<AggregationSelectItem, AggregationUnit>(){

                public AggregationUnit apply(AggregationSelectItem input) {
                    return AggregationUnitFactory.create(input.getType());
                }
            });
            aggregationMap.put(groupByValue, (Map<AggregationSelectItem, AggregationUnit>)map);
        }
    }

    private void aggregate(QueryResult queryResult, GroupByValue groupByValue, Map<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap) throws SQLException {
        for (AggregationSelectItem each : this.selectStatement.getAggregationSelectItems()) {
            ArrayList values = new ArrayList(2);
            if (each.getDerivedAggregationSelectItems().isEmpty()) {
                values.add(this.getAggregationValue(queryResult, each));
            } else {
                for (AggregationSelectItem derived : each.getDerivedAggregationSelectItems()) {
                    values.add(this.getAggregationValue(queryResult, derived));
                }
            }
            aggregationMap.get(groupByValue).get(each).merge(values);
        }
    }

    private Comparable<?> getAggregationValue(QueryResult queryResult, AggregationSelectItem aggregationSelectItem) throws SQLException {
        Object result = queryResult.getValue(aggregationSelectItem.getIndex(), Object.class);
        Preconditions.checkState((null == result || result instanceof Comparable ? 1 : 0) != 0, (Object)"Aggregation value must implements Comparable");
        return (Comparable)result;
    }

    private void setAggregationValueToMemoryRow(Map<GroupByValue, MemoryQueryResultRow> dataMap, Map<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap) {
        for (Map.Entry<GroupByValue, MemoryQueryResultRow> entry : dataMap.entrySet()) {
            for (AggregationSelectItem each : this.selectStatement.getAggregationSelectItems()) {
                entry.getValue().setCell(each.getIndex(), aggregationMap.get(entry.getKey()).get(each).getResult());
            }
        }
    }

    private List<MemoryQueryResultRow> getMemoryResultSetRows(Map<GroupByValue, MemoryQueryResultRow> dataMap) {
        ArrayList<MemoryQueryResultRow> result = new ArrayList<MemoryQueryResultRow>(dataMap.values());
        Collections.sort(result, new GroupByRowComparator(this.selectStatement));
        return result;
    }

    @Override
    public boolean next() {
        if (this.memoryResultSetRows.hasNext()) {
            this.setCurrentResultSetRow(this.memoryResultSetRows.next());
            return true;
        }
        return false;
    }
}

