/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.mysql.sql;

import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.clause.MySQLLimitClauseParser;
import io.shardingsphere.core.parsing.parser.dialect.mysql.clause.MySQLSelectOptionClauseParser;
import io.shardingsphere.core.parsing.parser.dialect.mysql.clause.facade.MySQLSelectClauseParserFacade;
import io.shardingsphere.core.parsing.parser.sql.dql.select.AbstractSelectParser;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.rule.ShardingRule;

public final class MySQLSelectParser
extends AbstractSelectParser {
    private final MySQLSelectOptionClauseParser selectOptionClauseParser;
    private final MySQLLimitClauseParser limitClauseParser;

    public MySQLSelectParser(ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        super(shardingRule, lexerEngine, new MySQLSelectClauseParserFacade(shardingRule, lexerEngine), shardingTableMetaData);
        this.selectOptionClauseParser = new MySQLSelectOptionClauseParser(lexerEngine);
        this.limitClauseParser = new MySQLLimitClauseParser(lexerEngine);
    }

    @Override
    protected void parseInternal(SelectStatement selectStatement) {
        this.parseSelectOption();
        this.parseSelectList(selectStatement, this.getItems());
        this.parseFrom(selectStatement);
        this.parseWhere(this.getShardingRule(), selectStatement, this.getItems());
        this.parseGroupBy(selectStatement);
        this.parseHaving();
        this.parseOrderBy(selectStatement);
        this.parseLimit(selectStatement);
        this.parseSelectRest();
    }

    private void parseSelectOption() {
        this.selectOptionClauseParser.parse();
    }

    private void parseLimit(SelectStatement selectStatement) {
        this.limitClauseParser.parse(selectStatement);
    }
}

