/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.sqlserver.clause;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.sqlserver.SQLServerKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Literals;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.context.limit.Limit;
import io.shardingsphere.core.parsing.parser.context.limit.LimitValue;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import java.beans.ConstructorProperties;

public final class SQLServerOffsetClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;

    public void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(SQLServerKeyword.OFFSET)) {
            return;
        }
        int offsetValue = -1;
        int offsetIndex = -1;
        if (this.lexerEngine.equalAny(Literals.INT)) {
            offsetValue = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
        } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            offsetIndex = selectStatement.getParametersIndex();
            selectStatement.increaseParametersIndex();
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.nextToken();
        Limit limit = new Limit();
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.FETCH)) {
            this.lexerEngine.nextToken();
            int rowCountValue = -1;
            int rowCountIndex = -1;
            this.lexerEngine.nextToken();
            if (this.lexerEngine.equalAny(Literals.INT)) {
                rowCountValue = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
            } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
                rowCountIndex = selectStatement.getParametersIndex();
                selectStatement.increaseParametersIndex();
            } else {
                throw new SQLParsingException(this.lexerEngine);
            }
            this.lexerEngine.nextToken();
            this.lexerEngine.nextToken();
            limit.setRowCount(new LimitValue(rowCountValue, rowCountIndex, false));
            limit.setOffset(new LimitValue(offsetValue, offsetIndex, true));
        } else {
            limit.setOffset(new LimitValue(offsetValue, offsetIndex, true));
        }
        selectStatement.setLimit(limit);
    }

    @ConstructorProperties(value={"lexerEngine"})
    public SQLServerOffsetClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
    }
}

