/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.rewrite;

import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.token.SQLToken;
import io.shardingsphere.core.parsing.parser.token.SchemaToken;
import io.shardingsphere.core.rewrite.SQLBuilder;
import io.shardingsphere.core.rewrite.placeholder.SchemaPlaceholder;
import io.shardingsphere.core.rule.MasterSlaveRule;
import java.util.Collections;
import java.util.List;

public final class MasterSlaveSQLRewriteEngine {
    private final MasterSlaveRule masterSlaveRule;
    private final String originalSQL;
    private final List<SQLToken> sqlTokens;
    private final ShardingMetaData metaData;

    public MasterSlaveSQLRewriteEngine(MasterSlaveRule masterSlaveRule, String originalSQL, SQLStatement sqlStatement, ShardingMetaData metaData) {
        this.masterSlaveRule = masterSlaveRule;
        this.originalSQL = originalSQL;
        this.sqlTokens = sqlStatement.getSQLTokens();
        this.metaData = metaData;
    }

    public String rewrite() {
        if (this.sqlTokens.isEmpty()) {
            return this.originalSQL;
        }
        SQLBuilder result = new SQLBuilder(Collections.emptyList());
        int count = 0;
        for (SQLToken each : this.sqlTokens) {
            if (0 == count) {
                result.appendLiterals(this.originalSQL.substring(0, each.getBeginPosition()));
            }
            if (each instanceof SchemaToken) {
                this.appendSchemaPlaceholder(this.originalSQL, result, (SchemaToken)each, count);
            }
            ++count;
        }
        return result.toSQL(this.masterSlaveRule, this.metaData.getDataSource());
    }

    private void appendSchemaPlaceholder(String sql, SQLBuilder sqlBuilder, SchemaToken schemaToken, int count) {
        sqlBuilder.appendPlaceholder(new SchemaPlaceholder(schemaToken.getSchemaName().toLowerCase(), null));
        int beginPosition = schemaToken.getBeginPosition() + schemaToken.getOriginalLiterals().length();
        int endPosition = this.sqlTokens.size() - 1 == count ? sql.length() : this.sqlTokens.get(count + 1).getBeginPosition();
        sqlBuilder.appendLiterals(sql.substring(beginPosition, endPosition));
    }
}

