/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.defaultdb;

import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.RoutingTable;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;

public final class DefaultDatabaseRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final Collection<String> logicTables;

    @Override
    public RoutingResult route() {
        RoutingResult result = new RoutingResult();
        ArrayList<RoutingTable> routingTables = new ArrayList<RoutingTable>(this.logicTables.size());
        for (String each : this.logicTables) {
            routingTables.add(new RoutingTable(each, each));
        }
        TableUnit tableUnit = new TableUnit(this.shardingRule.getShardingDataSourceNames().getDefaultDataSourceName());
        tableUnit.getRoutingTables().addAll(routingTables);
        result.getTableUnits().getTableUnits().add(tableUnit);
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "logicTables"})
    public DefaultDatabaseRoutingEngine(ShardingRule shardingRule, Collection<String> logicTables) {
        this.shardingRule = shardingRule;
        this.logicTables = logicTables;
    }
}

