/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.rule;

import io.shardingsphere.api.config.rule.MasterSlaveRuleConfiguration;
import io.shardingsphere.api.config.rule.ShardingRuleConfiguration;
import java.util.Collection;
import java.util.LinkedHashSet;

public final class ShardingDataSourceNames {
    private final ShardingRuleConfiguration shardingRuleConfig;
    private final Collection<String> dataSourceNames;

    public ShardingDataSourceNames(ShardingRuleConfiguration shardingRuleConfig, Collection<String> rawDataSourceNames) {
        this.shardingRuleConfig = shardingRuleConfig;
        this.dataSourceNames = this.getAllDataSourceNames(rawDataSourceNames);
    }

    private Collection<String> getAllDataSourceNames(Collection<String> dataSourceNames) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(dataSourceNames);
        for (MasterSlaveRuleConfiguration each : this.shardingRuleConfig.getMasterSlaveRuleConfigs()) {
            result.remove(each.getMasterDataSourceName());
            result.removeAll(each.getSlaveDataSourceNames());
            result.add(each.getName());
        }
        return result;
    }

    public String getDefaultDataSourceName() {
        return 1 == this.dataSourceNames.size() ? this.dataSourceNames.iterator().next() : this.shardingRuleConfig.getDefaultDataSourceName();
    }

    public String getRawMasterDataSourceName(String dataSourceName) {
        for (MasterSlaveRuleConfiguration each : this.shardingRuleConfig.getMasterSlaveRuleConfigs()) {
            if (!each.getName().equals(dataSourceName)) continue;
            return each.getMasterDataSourceName();
        }
        return dataSourceName;
    }

    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }
}

