/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.adapter;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.bootstrap.ShardingBootstrap;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationDataSource;
import io.shardingsphere.transaction.core.datasource.ShardingTransactionalDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;

public abstract class AbstractDataSourceAdapter
extends AbstractUnsupportedOperationDataSource
implements AutoCloseable {
    private final DatabaseType databaseType;
    private final ShardingTransactionalDataSource shardingTransactionalDataSources;
    private PrintWriter logWriter = new PrintWriter(System.out);

    public AbstractDataSourceAdapter(Map<String, DataSource> dataSourceMap) throws SQLException {
        this.databaseType = this.getDatabaseType(dataSourceMap.values());
        this.shardingTransactionalDataSources = new ShardingTransactionalDataSource(this.databaseType, dataSourceMap);
    }

    protected final DatabaseType getDatabaseType(Collection<DataSource> dataSources) throws SQLException {
        DatabaseType result = null;
        for (DataSource each : dataSources) {
            DatabaseType databaseType = this.getDatabaseType(each);
            Preconditions.checkState((null == result || result.equals((Object)databaseType) ? 1 : 0) != 0, (Object)String.format("Database type inconsistent with '%s' and '%s'", result, databaseType));
            result = databaseType;
        }
        return result;
    }

    private DatabaseType getDatabaseType(DataSource dataSource) throws SQLException {
        if (dataSource instanceof AbstractDataSourceAdapter) {
            return ((AbstractDataSourceAdapter)dataSource).databaseType;
        }
        try (Connection connection = dataSource.getConnection();){
            DatabaseType databaseType = DatabaseType.valueFrom((String)connection.getMetaData().getDatabaseProductName());
            return databaseType;
        }
    }

    public final Map<String, DataSource> getDataSourceMap() {
        return this.shardingTransactionalDataSources.getOriginalDataSourceMap();
    }

    @Override
    public final Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    @Override
    public final Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public void close() {
        this.shardingTransactionalDataSources.close();
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public ShardingTransactionalDataSource getShardingTransactionalDataSources() {
        return this.shardingTransactionalDataSources;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    static {
        ShardingBootstrap.init();
    }
}

