/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.adapter;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.table.TableMetaData;
import io.shardingsphere.core.metadata.table.TableMetaDataFactory;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.CreateTableStatement;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.DropTableStatement;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.shardingjdbc.jdbc.adapter.executor.ForceExecuteCallback;
import io.shardingsphere.shardingjdbc.jdbc.adapter.executor.ForceExecuteTemplate;
import io.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import io.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationStatement;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;

public abstract class AbstractStatementAdapter
extends AbstractUnsupportedOperationStatement {
    private final Class<? extends Statement> targetClass;
    private boolean closed;
    private boolean poolable;
    private int fetchSize;
    private final ForceExecuteTemplate<Statement> forceExecuteTemplate = new ForceExecuteTemplate();

    @Override
    public final void close() throws SQLException {
        this.closed = true;
        try {
            this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

                @Override
                public void execute(Statement statement) throws SQLException {
                    statement.close();
                }
            });
        }
        finally {
            this.getRoutedStatements().clear();
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public final void setPoolable(final boolean poolable) throws SQLException {
        this.poolable = poolable;
        this.recordMethodInvocation(this.targetClass, "setPoolable", new Class[]{Boolean.TYPE}, new Object[]{poolable});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setPoolable(poolable);
            }
        });
    }

    @Override
    public final int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public final void setFetchSize(final int rows) throws SQLException {
        this.fetchSize = rows;
        this.recordMethodInvocation(this.targetClass, "setFetchSize", new Class[]{Integer.TYPE}, new Object[]{rows});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setFetchSize(rows);
            }
        });
    }

    @Override
    public final void setEscapeProcessing(final boolean enable) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setEscapeProcessing", new Class[]{Boolean.TYPE}, new Object[]{enable});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setEscapeProcessing(enable);
            }
        });
    }

    @Override
    public final void cancel() throws SQLException {
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.cancel();
            }
        });
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        long result = 0L;
        boolean hasResult = false;
        for (Statement statement : this.getRoutedStatements()) {
            int updateCount = statement.getUpdateCount();
            if (updateCount > -1) {
                hasResult = true;
            }
            result += (long)updateCount;
        }
        if (result > Integer.MAX_VALUE) {
            result = Integer.MAX_VALUE;
        }
        return hasResult ? Long.valueOf(result).intValue() : -1;
    }

    @Override
    public final SQLWarning getWarnings() {
        return null;
    }

    @Override
    public final void clearWarnings() {
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        boolean result = false;
        for (Statement statement : this.getRoutedStatements()) {
            result = statement.getMoreResults();
        }
        return result;
    }

    @Override
    public final boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? 0 : this.getRoutedStatements().iterator().next().getMaxFieldSize();
    }

    @Override
    public final void setMaxFieldSize(final int max) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setMaxFieldSize", new Class[]{Integer.TYPE}, new Object[]{max});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setMaxFieldSize(max);
            }
        });
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? -1 : this.getRoutedStatements().iterator().next().getMaxRows();
    }

    @Override
    public final void setMaxRows(final int max) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setMaxRows", new Class[]{Integer.TYPE}, new Object[]{max});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setMaxRows(max);
            }
        });
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? 0 : this.getRoutedStatements().iterator().next().getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(final int seconds) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setQueryTimeout", new Class[]{Integer.TYPE}, new Object[]{seconds});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setQueryTimeout(seconds);
            }
        });
    }

    protected abstract Collection<? extends Statement> getRoutedStatements();

    protected final void refreshTableMetaData(ShardingContext shardingContext, SQLStatement sqlStatement) {
        if (sqlStatement instanceof CreateTableStatement) {
            this.refreshTableMetaData(shardingContext, (CreateTableStatement)sqlStatement);
        } else if (sqlStatement instanceof AlterTableStatement) {
            this.refreshTableMetaData(shardingContext, (AlterTableStatement)sqlStatement);
        } else if (sqlStatement instanceof DropTableStatement) {
            this.refreshTableMetaData(shardingContext, (DropTableStatement)sqlStatement);
        }
    }

    private void refreshTableMetaData(ShardingContext shardingContext, CreateTableStatement createTableStatement) {
        shardingContext.getMetaData().getTable().put(createTableStatement.getTables().getSingleTableName(), TableMetaDataFactory.newInstance((CreateTableStatement)createTableStatement));
    }

    private void refreshTableMetaData(ShardingContext shardingContext, AlterTableStatement alterTableStatement) {
        String logicTableName = alterTableStatement.getTables().getSingleTableName();
        TableMetaData newTableMetaData = TableMetaDataFactory.newInstance((AlterTableStatement)alterTableStatement, (TableMetaData)shardingContext.getMetaData().getTable().get(logicTableName));
        Optional newTableName = alterTableStatement.getNewTableName();
        if (newTableName.isPresent()) {
            shardingContext.getMetaData().getTable().put((String)newTableName.get(), newTableMetaData);
            shardingContext.getMetaData().getTable().remove(logicTableName);
        } else {
            shardingContext.getMetaData().getTable().put(logicTableName, newTableMetaData);
        }
    }

    private void refreshTableMetaData(ShardingContext shardingContext, DropTableStatement dropTableStatement) {
        for (String each : dropTableStatement.getTables().getTableNames()) {
            shardingContext.getMetaData().getTable().remove(each);
        }
    }

    @ConstructorProperties(value={"targetClass"})
    public AbstractStatementAdapter(Class<? extends Statement> targetClass) {
        this.targetClass = targetClass;
    }
}

