/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.core.loader;

import com.google.common.base.Optional;
import io.shardingsphere.spi.NewInstanceServiceLoader;
import io.shardingsphere.transaction.api.TransactionType;
import io.shardingsphere.transaction.spi.TransactionalDataSourceConverter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionalDataSourceConverterSPILoader {
    private static final Logger log = LoggerFactory.getLogger(TransactionalDataSourceConverterSPILoader.class);
    private static final Map<TransactionType, TransactionalDataSourceConverter> CONVERTERS = new HashMap<TransactionType, TransactionalDataSourceConverter>();

    public static Optional<TransactionalDataSourceConverter> findConverter(TransactionType type) {
        return Optional.fromNullable((Object)CONVERTERS.get((Object)type));
    }

    private TransactionalDataSourceConverterSPILoader() {
    }

    static {
        for (TransactionalDataSourceConverter each : NewInstanceServiceLoader.load(TransactionalDataSourceConverter.class)) {
            CONVERTERS.put(each.getType(), each);
        }
    }
}

