/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.HoverflyUtils;
import io.specto.hoverfly.junit.core.model.DelaySettings;
import io.specto.hoverfly.junit.core.model.GlobalActions;
import io.specto.hoverfly.junit.core.model.HoverflyData;
import io.specto.hoverfly.junit.core.model.HoverflyMetaData;
import io.specto.hoverfly.junit.core.model.Simulation;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@FunctionalInterface
public interface SimulationSource {
    public static SimulationSource url(URL url) {
        return () -> {
            String string;
            block8: {
                InputStream is = url.openStream();
                try {
                    string = HoverflyUtils.convertStreamToString(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Cannot read simulation", e);
                    }
                }
                is.close();
            }
            return string;
        };
    }

    public static SimulationSource url(String url) {
        return () -> {
            String string;
            block8: {
                InputStream is = new URL(url).openStream();
                try {
                    string = HoverflyUtils.convertStreamToString(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Cannot read simulation", e);
                    }
                }
                is.close();
            }
            return string;
        };
    }

    public static SimulationSource classpath(String classpath) {
        return () -> {
            String string;
            block8: {
                InputStream is = HoverflyUtils.getClasspathResourceAsStream(classpath);
                try {
                    string = HoverflyUtils.convertStreamToString(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Cannot load classpath resource: '" + classpath + "'", e);
                    }
                }
                is.close();
            }
            return string;
        };
    }

    public static SimulationSource defaultPath(String pathString) {
        return () -> {
            String string;
            block8: {
                String fullClasspath = "hoverfly/" + pathString;
                InputStream is = HoverflyUtils.getClasspathResourceAsStream(fullClasspath);
                try {
                    string = HoverflyUtils.convertStreamToString(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Cannot load default path resource: '" + pathString + "'", e);
                    }
                }
                is.close();
            }
            return string;
        };
    }

    public static SimulationSource file(Path path) {
        return () -> {
            String string;
            block8: {
                InputStream is = Files.newInputStream(path, new OpenOption[0]);
                try {
                    string = HoverflyUtils.convertStreamToString(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Cannot load file resource: '" + path.toString() + "'", e);
                    }
                }
                is.close();
            }
            return string;
        };
    }

    public static SimulationSource dsl(StubServiceBuilder ... stubServiceBuilder) {
        return () -> {
            Set pairs = Arrays.stream(stubServiceBuilder).map(StubServiceBuilder::getRequestResponsePairs).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            List<DelaySettings> delaySettings = Arrays.stream(stubServiceBuilder).map(StubServiceBuilder::getDelaySettings).flatMap(Collection::stream).collect(Collectors.toList());
            return HoverflyUtils.writeSimulationAsString(new Simulation(new HoverflyData(pairs, new GlobalActions(delaySettings)), new HoverflyMetaData()));
        };
    }

    public static SimulationSource simulation(Simulation simulation) {
        return () -> HoverflyUtils.writeSimulationAsString(simulation);
    }

    public static SimulationSource empty() {
        return () -> HoverflyUtils.writeSimulationAsString(Simulation.newEmptyInstance());
    }

    public String getSimulation();
}

