/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.config;

import io.specto.hoverfly.junit.core.HoverflyConstants;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

class HoverflyConfigValidator {
    HoverflyConfigValidator() {
    }

    HoverflyConfiguration validate(HoverflyConfiguration hoverflyConfig) {
        if (hoverflyConfig == null) {
            throw new IllegalArgumentException("HoverflyConfig cannot be null.");
        }
        if (hoverflyConfig.isRemoteInstance()) {
            if (hoverflyConfig.getHost() != null && hoverflyConfig.getHost().startsWith("http")) {
                try {
                    URI uri = new URI(hoverflyConfig.getHost());
                    hoverflyConfig.setHost(uri.getHost());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Remote hoverfly hostname is not valid: " + hoverflyConfig.getHost());
                }
            }
        } else {
            boolean isKeyBlank = StringUtils.isBlank((CharSequence)hoverflyConfig.getSslKeyPath());
            boolean isCertBlank = StringUtils.isBlank((CharSequence)hoverflyConfig.getSslCertificatePath());
            if (isKeyBlank && !isCertBlank || !isKeyBlank && isCertBlank) {
                throw new IllegalArgumentException("Both ca cert and key files are required to override the default Hoverfly ca cert.");
            }
            boolean isClientKeyBlank = StringUtils.isBlank((CharSequence)hoverflyConfig.getClientKeyPath());
            boolean isClientCertBlank = StringUtils.isBlank((CharSequence)hoverflyConfig.getClientCertPath());
            if (isClientKeyBlank && !isClientCertBlank || !isClientKeyBlank && isClientCertBlank) {
                throw new IllegalArgumentException("Both client cert and key files are required to enable mutual TLS authentication.");
            }
            if (hoverflyConfig.getProxyPort() == 0) {
                hoverflyConfig.setProxyPort(HoverflyConfigValidator.findUnusedPort());
            }
            if (hoverflyConfig.getAdminPort() == 0) {
                hoverflyConfig.setAdminPort(HoverflyConfigValidator.findUnusedPort());
            }
        }
        if (hoverflyConfig.getHealthCheckTimeout() == null) {
            hoverflyConfig.setHealthCheckTimeout(HoverflyConstants.DEFAULT_HEALTH_CHECK_TIMEOUT);
        }
        if (hoverflyConfig.getHealthCheckRetryInterval() == null) {
            hoverflyConfig.setHealthCheckRetryInterval(HoverflyConstants.DEFAULT_HEALTH_CHECK_RETRY_INTERVAL);
        }
        if (hoverflyConfig.getProxyCaCertificate().isPresent()) {
            this.checkResourceOnClasspath(hoverflyConfig.getProxyCaCertificate().get());
        }
        if (StringUtils.isBlank((CharSequence)hoverflyConfig.getResponseBodyFilesPath())) {
            this.getTestResourcesFolderPath("hoverfly").ifPresent(hoverflyConfig::setResponseBodyFilesPath);
        } else if (hoverflyConfig.isRelativeResponseBodyFilesPath()) {
            String path = this.getTestResourcesFolderPath(hoverflyConfig.getResponseBodyFilesPath()).orElseThrow(() -> new IllegalArgumentException("Response body files path not found: " + hoverflyConfig.getResponseBodyFilesPath()));
            hoverflyConfig.setResponseBodyFilesPath(path);
        }
        return hoverflyConfig;
    }

    private static int findUnusedPort() {
        int n;
        ServerSocket serverSocket = new ServerSocket(0);
        try {
            n = serverSocket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot find available port", e);
            }
        }
        serverSocket.close();
        return n;
    }

    private void checkResourceOnClasspath(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Optional.ofNullable(classLoader.getResource(resourceName)).orElseThrow(() -> new IllegalArgumentException("Resource not found with name: " + resourceName));
    }

    private Optional<String> getTestResourcesFolderPath(String relativePath) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(relativePath);
        return Optional.ofNullable(url).map(this::toPath);
    }

    private String toPath(URL url) {
        try {
            return Path.of(url.toURI()).toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

