/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.spring.data.rest.EntityRequestHandler;

class EntityRequestTemplate {
    private final ResourceMappings restMappings;
    private final Repositories repositories;
    private final RequestMappingInfo requestMappingInfo;
    private final HandlerMethod handlerMethod;
    private final TypeResolver typeResolver;

    EntityRequestTemplate(TypeResolver typeResolver, Repositories repositories, ResourceMappings restMappings, RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        this.typeResolver = typeResolver;
        this.repositories = repositories;
        this.restMappings = restMappings;
        this.requestMappingInfo = requestMappingInfo;
        this.handlerMethod = handlerMethod;
    }

    List<RequestHandler> operations() {
        ArrayList requestHandlers = Lists.newArrayList();
        for (ResourceMetadata resource : this.restMappings) {
            Class domainType = resource.getDomainType();
            RepositoryInformation entity = this.repositories.getRepositoryInformationFor(domainType);
            Class idType = entity.getIdType();
            requestHandlers.add(new EntityRequestHandler(this.typeResolver, resource, idType, domainType, this.requestMappingInfo, this.handlerMethod));
        }
        return requestHandlers;
    }
}

