/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.hateoas.alps.Alps;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.CombinedRequestHandler;

class EntitySchemaHandler
implements RequestHandler {
    private final TypeResolver resolver;
    private final ResourceMetadata resource;
    private final RequestMappingInfo requestMapping;
    private final HandlerMethod handlerMethod;

    EntitySchemaHandler(TypeResolver resolver, ResourceMetadata resource, RequestMappingInfo requestMapping, HandlerMethod handlerMethod) {
        this.resolver = resolver;
        this.resource = resource;
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
    }

    public Class<?> declaringClass() {
        return this.handlerMethod.getMethod().getDeclaringClass();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return null != AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation);
    }

    public PatternsRequestCondition getPatternsCondition() {
        HashSet patterns = Sets.newHashSet();
        for (String each : this.requestMapping.getPatternsCondition().getPatterns()) {
            String replaced = each.replace("/{repository}", this.resource.getPath().toString());
            patterns.add(replaced);
        }
        return new PatternsRequestCondition(patterns.toArray(new String[patterns.size()]));
    }

    public String groupName() {
        return "Entity Metadata Services";
    }

    public String getName() {
        return this.handlerMethod.getMethod().getName();
    }

    public Set<RequestMethod> supportedMethods() {
        return this.requestMapping.getMethodsCondition().getMethods();
    }

    public Set<? extends MediaType> produces() {
        return this.requestMapping.getProducesCondition().getProducibleMediaTypes();
    }

    public Set<? extends MediaType> consumes() {
        return this.requestMapping.getConsumesCondition().getConsumableMediaTypes();
    }

    public Set<NameValueExpression<String>> headers() {
        return this.requestMapping.getHeadersCondition().getExpressions();
    }

    public Set<NameValueExpression<String>> params() {
        return this.requestMapping.getParamsCondition().getExpressions();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation));
    }

    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.getPatternsCondition().getPatterns(), this.supportedMethods(), this.produces(), this.consumes());
    }

    public List<ResolvedMethodParameter> getParameters() {
        return Lists.newArrayList();
    }

    public ResolvedType getReturnType() {
        MemberResolver memberResolver = new MemberResolver(this.resolver);
        ResolvedTypeWithMembers members = memberResolver.resolve(this.resolver.resolve(this.handlerMethod.getMethod().getDeclaringClass(), new Type[0]), null, null);
        for (ResolvedMethod resolvedMethod : members.getMemberMethods()) {
            if (!((Method)resolvedMethod.getRawMember()).equals(this.handlerMethod.getMethod())) continue;
            ResolvedType resourceInfo = this.resolver.resolve(HttpEntity.class, new Type[]{RootResourceInformation.class});
            if (resourceInfo.equals((Object)resolvedMethod.getReturnType())) {
                return this.resolver.resolve(Alps.class, new Type[0]);
            }
            return resolvedMethod.getReturnType();
        }
        return this.resolver.resolve(Void.TYPE, new Type[0]);
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)this.handlerMethod.getBeanType(), annotation));
    }

    public RequestMappingInfo getRequestMapping() {
        return this.requestMapping;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    public RequestHandler combine(RequestHandler other) {
        return new CombinedRequestHandler(this, other);
    }
}

