/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.schema.contexts;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import springfox.documentation.builders.ModelBuilder;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;

public class ModelContext {
    private final String parameterId;
    private final ResolvedType type;
    private final boolean returnType;
    private final String groupName;
    private final DocumentationType documentationType;
    private final Optional<ResolvedType> view;
    private final Set<ResolvedType> validationGroups;
    private final ModelContext parentContext;
    private final Set<ResolvedType> seenTypes = new HashSet<ResolvedType>();
    private final ModelBuilder modelBuilder;
    private final AlternateTypeProvider alternateTypeProvider;
    private final GenericTypeNamingStrategy genericNamingStrategy;
    private final Set<Class> ignorableTypes;
    private final Map<ResolvedType, String> registeredTypes;

    private ModelContext(String parameterId, String groupName, ResolvedType type, boolean returnType, Optional<ResolvedType> view, Set<ResolvedType> validationGroups, DocumentationType documentationType, AlternateTypeProvider alternateTypeProvider, GenericTypeNamingStrategy genericNamingStrategy, Set<Class> ignorableTypes) {
        this.parameterId = parameterId;
        this.groupName = groupName;
        this.documentationType = documentationType;
        this.alternateTypeProvider = alternateTypeProvider;
        this.genericNamingStrategy = genericNamingStrategy;
        this.ignorableTypes = ignorableTypes;
        this.registeredTypes = new HashMap<ResolvedType, String>();
        this.parentContext = null;
        this.type = type;
        this.returnType = returnType;
        this.view = view;
        this.validationGroups = new HashSet<ResolvedType>(validationGroups);
        this.modelBuilder = new ModelBuilder(this.getModelId());
    }

    private ModelContext(ModelContext parentContext, ResolvedType input) {
        this.parameterId = parentContext.parameterId;
        this.parentContext = parentContext;
        this.type = input;
        this.groupName = parentContext.groupName;
        this.returnType = parentContext.isReturnType();
        this.view = parentContext.getView();
        this.validationGroups = parentContext.getValidationGroups();
        this.documentationType = parentContext.getDocumentationType();
        this.alternateTypeProvider = parentContext.alternateTypeProvider;
        this.ignorableTypes = parentContext.ignorableTypes;
        this.registeredTypes = parentContext.registeredTypes;
        this.genericNamingStrategy = parentContext.getGenericNamingStrategy();
        this.modelBuilder = new ModelBuilder(this.getModelId());
    }

    public ResolvedType getType() {
        return this.type;
    }

    public String getParameterId() {
        return this.parameterId;
    }

    public String getModelId() {
        return this.type.getBriefDescription();
    }

    public String getTypeId() {
        return this.parameterId + "_" + this.getModelId();
    }

    public ResolvedType resolvedType(TypeResolver resolver) {
        return resolver.resolve((Type)this.getType(), new Type[0]);
    }

    public boolean isReturnType() {
        return this.returnType;
    }

    public Optional<ResolvedType> getView() {
        return this.view;
    }

    public Set<ResolvedType> getValidationGroups() {
        return this.validationGroups;
    }

    public AlternateTypeProvider getAlternateTypeProvider() {
        return this.alternateTypeProvider;
    }

    public ResolvedType alternateFor(ResolvedType resolved) {
        return this.alternateTypeProvider.alternateFor(resolved);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public static ModelContext inputParam(String parameterId, String group, ResolvedType type, Optional<ResolvedType> view, Set<ResolvedType> validationGroups, DocumentationType documentationType, AlternateTypeProvider alternateTypeProvider, GenericTypeNamingStrategy genericNamingStrategy, Set<Class> ignorableTypes) {
        return new ModelContext(parameterId, group, type, false, view, validationGroups, documentationType, alternateTypeProvider, genericNamingStrategy, ignorableTypes);
    }

    public static ModelContext returnValue(String parameterId, String groupName, ResolvedType type, Optional<ResolvedType> view, DocumentationType documentationType, AlternateTypeProvider alternateTypeProvider, GenericTypeNamingStrategy genericNamingStrategy, Set<Class> ignorableTypes) {
        return new ModelContext(parameterId, groupName, type, true, view, new HashSet<ResolvedType>(), documentationType, alternateTypeProvider, genericNamingStrategy, ignorableTypes);
    }

    public static ModelContext fromParent(ModelContext context, ResolvedType input) {
        return new ModelContext(context, input);
    }

    public boolean hasSeenBefore(ResolvedType resolvedType) {
        return this.seenTypes.contains(resolvedType) || this.seenTypes.contains(new TypeResolver().resolve((Type)resolvedType.getErasedType(), new Type[0])) || this.parentHasSeenBefore(resolvedType);
    }

    public DocumentationType getDocumentationType() {
        return this.documentationType;
    }

    private boolean parentHasSeenBefore(ResolvedType resolvedType) {
        if (this.parentContext == null) {
            return false;
        }
        return this.parentContext.hasSeenBefore(resolvedType);
    }

    public GenericTypeNamingStrategy getGenericNamingStrategy() {
        if (this.parentContext == null) {
            return this.genericNamingStrategy;
        }
        return this.parentContext.getGenericNamingStrategy();
    }

    public ModelBuilder getBuilder() {
        return this.modelBuilder;
    }

    public void seen(ResolvedType resolvedType) {
        this.seenTypes.add(resolvedType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelContext that = (ModelContext)o;
        return Objects.equals(this.groupName, that.groupName) && Objects.equals(this.type, that.type) && Objects.equals(this.view, that.view) && Objects.equals(this.validationGroups, that.validationGroups) && Objects.equals((Object)this.documentationType, (Object)that.documentationType) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.namingStrategy(), that.namingStrategy());
    }

    private String namingStrategy() {
        if (this.genericNamingStrategy != null) {
            return this.genericNamingStrategy.getClass().getName();
        }
        return "";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupName, this.type, this.view, this.validationGroups, this.documentationType, this.returnType, this.namingStrategy()});
    }

    public String description() {
        return this.getClass().getSimpleName() + "{" + "groupName=" + this.getGroupName() + ", " + "type=" + this.getType() + ", " + "isReturnType=" + this.isReturnType() + ", " + "view=" + this.getView() + "}";
    }

    public boolean canIgnore(ResolvedType type) {
        return this.ignorableTypes.contains(type.getErasedType());
    }
}

