/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ExampleProperty;
import io.swagger.annotations.ResponseHeader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.Header;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.ResponseMessagesReader;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.operation.ResponseHeaders;

@Component
@Order(value=-2147482648)
public class SwaggerResponseMessageReader
implements OperationBuilderPlugin {
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final TypeNameExtractor typeNameExtractor;
    private final TypeResolver typeResolver;

    @Autowired
    public SwaggerResponseMessageReader(EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor typeNameExtractor, TypeResolver typeResolver) {
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.typeNameExtractor = typeNameExtractor;
        this.typeResolver = typeResolver;
    }

    public void apply(OperationContext context) {
        context.operationBuilder().responseMessages(this.read(context));
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    protected Set<ResponseMessage> read(OperationContext context) {
        ResolvedType defaultResponse = context.getReturnType();
        Optional operationAnnotation = context.findAnnotation(ApiOperation.class);
        Optional<ResolvedType> operationResponse = operationAnnotation.map(Annotations.resolvedTypeFromOperation(this.typeResolver, defaultResponse));
        Optional<ResponseHeader[]> defaultResponseHeaders = operationAnnotation.map(ApiOperation::responseHeaders);
        HashMap defaultHeaders = new HashMap();
        defaultResponseHeaders.ifPresent(responseHeaders -> defaultHeaders.putAll(ResponseHeaders.headers(responseHeaders)));
        List allApiResponses = context.findAllAnnotations(ApiResponses.class);
        HashSet<ResponseMessage> responseMessages = new HashSet<ResponseMessage>();
        HashMap<Integer, ApiResponse> seenResponsesByCode = new HashMap<Integer, ApiResponse>();
        for (ApiResponses apiResponses : allApiResponses) {
            ApiResponse[] apiResponseAnnotations;
            for (ApiResponse apiResponse : apiResponseAnnotations = apiResponses.value()) {
                if (seenResponsesByCode.containsKey(apiResponse.code())) continue;
                seenResponsesByCode.put(apiResponse.code(), apiResponse);
                Optional<Object> responseModel = Optional.empty();
                ModelContext modelContext = context.operationModelsBuilder().addReturn(this.typeResolver.resolve((Type)apiResponse.response(), new Type[0]), Optional.empty());
                Optional<ResolvedType> type = this.resolvedType(apiResponse);
                if (SwaggerResponseMessageReader.isSuccessful(apiResponse.code())) {
                    type = type.map(Optional::of).orElse(operationResponse);
                }
                if (type.isPresent()) {
                    HashMap knownNames = new HashMap();
                    ((Set)Optional.ofNullable(context.getKnownModels().get(modelContext.getParameterId())).orElse(new HashSet())).forEach(model -> knownNames.put(model.getId(), model.getName()));
                    responseModel = Optional.of(ResolvedTypes.modelRefFactory((ModelContext)modelContext, (EnumTypeDeterminer)this.enumTypeDeterminer, (TypeNameExtractor)this.typeNameExtractor, knownNames).apply(context.alternateFor(type.get())));
                }
                ArrayList<Example> examples = new ArrayList<Example>();
                for (ExampleProperty exampleProperty : apiResponse.examples().value()) {
                    if (StringUtils.isEmpty((Object)exampleProperty.value())) continue;
                    String mediaType = StringUtils.isEmpty((Object)exampleProperty.mediaType()) ? null : exampleProperty.mediaType();
                    examples.add(new Example(mediaType, (Object)exampleProperty.value()));
                }
                HashMap<String, Header> headers = new HashMap<String, Header>(defaultHeaders);
                headers.putAll(ResponseHeaders.headers(apiResponse.responseHeaders()));
                responseMessages.add(new ResponseMessageBuilder().code(apiResponse.code()).message(apiResponse.message()).responseModel((ModelReference)responseModel.orElse(null)).examples(examples).headersWithDescription(headers).build());
            }
        }
        if (operationResponse.isPresent()) {
            ModelContext modelContext = context.operationModelsBuilder().addReturn(operationResponse.get(), Optional.empty());
            ResolvedType resolvedType = context.alternateFor(operationResponse.get());
            HashMap knownNames = new HashMap();
            ((Set)Optional.ofNullable(context.getKnownModels().get(modelContext.getParameterId())).orElse(new HashSet())).forEach(model -> knownNames.put(model.getId(), model.getName()));
            ModelReference responseModel = (ModelReference)ResolvedTypes.modelRefFactory((ModelContext)modelContext, (EnumTypeDeterminer)this.enumTypeDeterminer, (TypeNameExtractor)this.typeNameExtractor, knownNames).apply(resolvedType);
            context.operationBuilder().responseModel(responseModel);
            ResponseMessage defaultMessage = new ResponseMessageBuilder().code(ResponseMessagesReader.httpStatusCode((OperationContext)context)).message(ResponseMessagesReader.message((OperationContext)context)).responseModel(responseModel).build();
            if (!responseMessages.contains(defaultMessage) && !"void".equals(responseModel.getType())) {
                responseMessages.add(defaultMessage);
            }
        }
        return responseMessages;
    }

    static boolean isSuccessful(int code) {
        try {
            return HttpStatus.Series.SUCCESSFUL.equals((Object)HttpStatus.Series.valueOf((int)code));
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private Optional<ResolvedType> resolvedType(ApiResponse apiResponse) {
        return Optional.ofNullable(Annotations.resolvedTypeFromResponse(this.typeResolver, null).apply(apiResponse));
    }
}

