/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.fasterxml.classmate.ResolvedType;
import io.swagger.models.ComposedModel;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mapstruct.Mapper;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.ApiListing;
import springfox.documentation.swagger2.mappers.EnumMapper;
import springfox.documentation.swagger2.mappers.InheritanceDeterminer;
import springfox.documentation.swagger2.mappers.Properties;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Mapper
public abstract class ModelMapper {
    public Map<String, io.swagger.models.Model> mapModels(Map<String, Model> from) {
        if (from == null) {
            return null;
        }
        TreeMap<String, io.swagger.models.Model> map = new TreeMap<String, io.swagger.models.Model>();
        InheritanceDeterminer determiner = new InheritanceDeterminer(from);
        for (Map.Entry<String, Model> entry : from.entrySet()) {
            String key = entry.getKey();
            io.swagger.models.Model value = determiner.hasParent(entry.getValue()) ? this.mapComposedModel(determiner.parent(entry.getValue()), entry.getValue()) : this.mapModel(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    private io.swagger.models.Model mapComposedModel(RefModel parent, Model source) {
        ComposedModel model = new ComposedModel().interfaces(Collections.singletonList(parent)).child(this.mapModel(source));
        model.setDescription(source.getDescription());
        model.setExample(source.getExample());
        model.setTitle(source.getName());
        SortedMap<String, ModelProperty> sortedProperties = this.sort(source.getProperties());
        Map<String, Property> modelProperties = this.mapProperties(sortedProperties);
        model.setProperties(modelProperties);
        return model;
    }

    private io.swagger.models.Model mapModel(Model source) {
        ModelImpl model = new ModelImpl().description(source.getDescription()).discriminator(source.getDiscriminator()).example(source.getExample()).name(source.getName()).xml(this.mapXml(source.getXml()));
        SortedMap<String, ModelProperty> sortedProperties = this.sort(source.getProperties());
        Map<String, Property> modelProperties = this.mapProperties(sortedProperties);
        model.setProperties(modelProperties);
        Stream<String> requiredFields = source.getProperties().values().stream().filter(this.requiredProperty()).map(this.propertyName());
        model.setRequired(requiredFields.collect(Collectors.toList()));
        model.setSimple(false);
        model.setType("object");
        model.setTitle(source.getName());
        if (Maps.isMapType((ResolvedType)source.getType())) {
            Optional<Class> clazz = this.typeOfValue(source);
            if (clazz.isPresent()) {
                model.additionalProperties(Properties.property(clazz.get().getSimpleName()));
            } else {
                model.additionalProperties((Property)new ObjectProperty());
            }
        }
        return model;
    }

    private Map<String, Property> mapProperties(SortedMap<String, ModelProperty> properties) {
        LinkedHashMap<String, Property> mappedProperties = new LinkedHashMap<String, Property>();
        properties.entrySet().stream().filter(Properties.voidProperties().negate()).forEachOrdered(propertyEntry -> mappedProperties.put((String)propertyEntry.getKey(), this.mapProperty((ModelProperty)propertyEntry.getValue())));
        return mappedProperties;
    }

    private SortedMap<String, ModelProperty> sort(Map<String, ModelProperty> modelProperties) {
        TreeMap<String, ModelProperty> sortedMap = new TreeMap<String, ModelProperty>(Properties.defaultOrdering(modelProperties));
        sortedMap.putAll(modelProperties);
        return sortedMap;
    }

    Optional<Class> typeOfValue(Model source) {
        Optional<ResolvedType> mapInterface = this.findMapInterface(source.getType());
        if (mapInterface.isPresent()) {
            if (mapInterface.get().getTypeParameters().size() == 2) {
                return Optional.of(((ResolvedType)mapInterface.get().getTypeParameters().get(1)).getErasedType());
            }
            return Optional.of(Object.class);
        }
        return Optional.empty();
    }

    private Optional<ResolvedType> findMapInterface(ResolvedType type) {
        return Optional.ofNullable(type.findSupertype(Map.class));
    }

    private Property mapProperty(ModelProperty source) {
        AllowableRangeValues range;
        AllowableValues allowableValues;
        Property property = ModelMapper.modelRefToProperty(source.getModelRef());
        EnumMapper.maybeAddAllowableValues(property, source.getAllowableValues());
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            EnumMapper.maybeAddAllowableValues(arrayProperty.getItems(), source.getAllowableValues());
        }
        if (property instanceof AbstractNumericProperty) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)property;
            allowableValues = source.getAllowableValues();
            if (allowableValues instanceof AllowableRangeValues) {
                range = (AllowableRangeValues)allowableValues;
                numericProperty.maximum(EnumMapper.safeBigDecimal(range.getMax()));
                numericProperty.exclusiveMaximum(range.getExclusiveMax());
                numericProperty.minimum(EnumMapper.safeBigDecimal(range.getMin()));
                numericProperty.exclusiveMinimum(range.getExclusiveMin());
            }
        }
        if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            allowableValues = source.getAllowableValues();
            if (allowableValues instanceof AllowableRangeValues) {
                range = (AllowableRangeValues)allowableValues;
                stringProperty.maxLength(ModelMapper.safeInteger(range.getMax()));
                stringProperty.minLength(ModelMapper.safeInteger(range.getMin()));
            }
            if (source.getPattern() != null) {
                stringProperty.setPattern(source.getPattern());
            }
            stringProperty.setDefault(source.getDefaultValue());
        }
        Map<String, Object> extensions = new VendorExtensionsMapper().mapExtensions(source.getVendorExtensions());
        if (property != null) {
            property.setDescription(source.getDescription());
            property.setName(source.getName());
            property.setRequired(source.isRequired().booleanValue());
            property.setReadOnly(source.isReadOnly());
            property.setAllowEmptyValue(source.isAllowEmptyValue());
            property.setExample(source.getExample());
            property.getVendorExtensions().putAll(extensions);
            property.setXml(this.mapXml(source.getXml()));
        }
        return property;
    }

    private io.swagger.models.Xml mapXml(Xml xml) {
        if (xml == null) {
            return null;
        }
        return new io.swagger.models.Xml().name(xml.getName()).attribute(xml.getAttribute()).namespace(xml.getNamespace()).prefix(xml.getPrefix()).wrapped(xml.getWrapped());
    }

    static Integer safeInteger(String doubleString) {
        try {
            return Integer.valueOf(doubleString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static Property modelRefToProperty(ModelReference modelRef) {
        if (modelRef == null || "void".equalsIgnoreCase(modelRef.getType())) {
            return null;
        }
        Object responseProperty = modelRef.isCollection() ? Properties.property(modelRef) : (modelRef.isMap() ? new MapProperty(Properties.property((ModelReference)modelRef.itemModel().get())) : Properties.property(modelRef.getType()));
        EnumMapper.maybeAddAllowableValues(responseProperty, modelRef.getAllowableValues());
        return responseProperty;
    }

    Map<String, io.swagger.models.Model> modelsFromApiListings(Map<String, List<ApiListing>> apiListings) {
        TreeMap<String, Model> definitions = new TreeMap<String, Model>();
        apiListings.values().stream().flatMap(Collection::stream).forEachOrdered(each -> definitions.putAll(each.getModels()));
        return this.mapModels(definitions);
    }

    private Function<ModelProperty, String> propertyName() {
        return input -> input.getName();
    }

    private Predicate<ModelProperty> requiredProperty() {
        return input -> input.isRequired();
    }
}

