/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.Property;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mapstruct.Mapper;
import org.springframework.util.StringUtils;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;
import springfox.documentation.swagger2.mappers.EnumMapper;
import springfox.documentation.swagger2.mappers.Properties;
import springfox.documentation.swagger2.mappers.SerializableParameterFactories;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Mapper
public class ParameterMapper {
    private static final Set<String> SUPPORTED_FORM_DATA_TYPES = Stream.of("string", "number", "integer", "boolean", "array", "file").collect(Collectors.toSet());
    private static final VendorExtensionsMapper VENDOR_EXTENSIONS_MAPPER = new VendorExtensionsMapper();

    public Parameter mapParameter(springfox.documentation.service.Parameter source) {
        Parameter parameter = "formData".equals(source.getParamType()) ? this.formParameter(source) : this.bodyParameter(source);
        return SerializableParameterFactories.create(source).orElse(parameter);
    }

    private Parameter formParameter(springfox.documentation.service.Parameter source) {
        FormParameter parameter = (FormParameter)((FormParameter)new FormParameter().name(source.getName())).description(source.getDescription());
        ModelReference modelRef = source.getModelRef();
        parameter.setProperty(Properties.itemTypeProperty(modelRef));
        if (!SUPPORTED_FORM_DATA_TYPES.contains(parameter.getType()) || "array".equals(parameter.getType()) && !SUPPORTED_FORM_DATA_TYPES.contains(parameter.getItems().getType())) {
            return this.bodyParameter(source);
        }
        parameter.setIn(source.getParamType());
        parameter.setAccess(source.getParamAccess());
        parameter.setPattern(source.getPattern());
        parameter.setRequired(source.isRequired().booleanValue());
        parameter.getVendorExtensions().putAll(VENDOR_EXTENSIONS_MAPPER.mapExtensions(source.getVendorExtentions()));
        for (Map.Entry each : source.getExamples().entrySet()) {
            Optional example = ((List)each.getValue()).stream().findFirst();
            if (!example.isPresent() || ((Example)example.get()).getValue() == null) continue;
            parameter.example(String.valueOf(((Example)example.get()).getValue()));
            break;
        }
        return parameter;
    }

    private Parameter bodyParameter(springfox.documentation.service.Parameter source) {
        BodyParameter parameter = new BodyParameter().description(source.getDescription()).name(source.getName()).schema(this.toSchema(source));
        parameter.setIn(source.getParamType());
        parameter.setAccess(source.getParamAccess());
        parameter.setPattern(source.getPattern());
        parameter.setRequired(source.isRequired().booleanValue());
        parameter.getVendorExtensions().putAll(VENDOR_EXTENSIONS_MAPPER.mapExtensions(source.getVendorExtentions()));
        for (Map.Entry each : source.getExamples().entrySet()) {
            Optional example = ((List)each.getValue()).stream().findFirst();
            if (!example.isPresent() || ((Example)example.get()).getValue() == null) continue;
            parameter.addExample((String)each.getKey(), String.valueOf(((Example)example.get()).getValue()));
        }
        return parameter;
    }

    private Model toSchema(springfox.documentation.service.Parameter source) {
        Model schema = this.fromModelRef(source.getModelRef());
        if (!StringUtils.isEmpty((Object)source.getScalarExample()) && !this.isEmptyExample(source.getScalarExample())) {
            schema.setExample(source.getScalarExample());
        }
        return schema;
    }

    private boolean isEmptyExample(Object object) {
        return object instanceof Example && StringUtils.isEmpty((Object)((Example)object).getValue());
    }

    Model fromModelRef(ModelReference modelRef) {
        if (modelRef.isCollection()) {
            if (modelRef.getItemType().equals("byte")) {
                ModelImpl baseModel = new ModelImpl();
                baseModel.setType("string");
                baseModel.setFormat("byte");
                return EnumMapper.maybeAddAllowableValuesToParameter(baseModel, modelRef.getAllowableValues());
            }
            if (modelRef.getItemType().equals("file")) {
                ArrayModel files = new ArrayModel();
                files.items((Property)new FileProperty());
                return files;
            }
            ModelReference itemModel = (ModelReference)modelRef.itemModel().get();
            return new ArrayModel().items(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty(itemModel), itemModel.getAllowableValues()));
        }
        if (modelRef.isMap()) {
            ModelImpl baseModel = new ModelImpl();
            ModelReference itemModel = (ModelReference)modelRef.itemModel().get();
            baseModel.additionalProperties(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty(itemModel), itemModel.getAllowableValues()));
            return baseModel;
        }
        if (Types.isBaseType((String)modelRef.getType())) {
            Property property = Properties.property(modelRef.getType());
            ModelImpl baseModel = new ModelImpl();
            baseModel.setType(property.getType());
            baseModel.setFormat(property.getFormat());
            return EnumMapper.maybeAddAllowableValuesToParameter(baseModel, modelRef.getAllowableValues());
        }
        return new RefModel(modelRef.getType());
    }
}

