/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.collect.Multimap;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Operation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.swagger2.mappers.LicenseMapper;
import springfox.documentation.swagger2.mappers.ModelMapper;
import springfox.documentation.swagger2.mappers.ParameterMapper;
import springfox.documentation.swagger2.mappers.SecurityMapper;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Component
public class ServiceModelToSwagger2MapperImpl
extends ServiceModelToSwagger2Mapper {
    @Autowired
    private ModelMapper modelMapper;
    @Autowired
    private ParameterMapper parameterMapper;
    @Autowired
    private SecurityMapper securityMapper;
    @Autowired
    private LicenseMapper licenseMapper;
    @Autowired
    private VendorExtensionsMapper vendorExtensionsMapper;

    @Override
    public Swagger mapDocumentation(Documentation from) {
        List list___;
        List list__;
        Map<String, SecuritySchemeDefinition> map___;
        Map<String, Model> map_;
        if (from == null) {
            return null;
        }
        Swagger swagger = new Swagger();
        Map<String, Object> map = this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions());
        if (map != null) {
            swagger.setVendorExtensions(map);
        }
        swagger.setHost(from.getHost());
        List<Scheme> list = this.mapSchemes(from.getSchemes());
        if (list != null) {
            swagger.setSchemes(list);
        }
        if ((map_ = this.modelMapper.modelsFromApiListings((Multimap<String, ApiListing>)from.getApiListings())) != null) {
            swagger.setDefinitions(map_);
        }
        swagger.setInfo(this.mapApiInfo(this.fromResourceListingInfo(from)));
        Map<String, Path> map__ = this.mapApiListings((Multimap<String, ApiListing>)from.getApiListings());
        if (map__ != null) {
            swagger.setPaths(map__);
        }
        if ((map___ = this.securityMapper.toSecuritySchemeDefinitions(from.getResourceListing())) != null) {
            swagger.setSecurityDefinitions(map___);
        }
        swagger.setBasePath(from.getBasePath());
        List<Tag> list_ = this.tagSetToTagList(from.getTags());
        if (list_ != null) {
            swagger.setTags(list_);
        }
        if ((list__ = from.getConsumes()) != null) {
            swagger.setConsumes(new ArrayList(list__));
        }
        if ((list___ = from.getProduces()) != null) {
            swagger.setProduces(new ArrayList(list___));
        }
        return swagger;
    }

    @Override
    protected Info mapApiInfo(ApiInfo from) {
        Map<String, Object> map;
        if (from == null) {
            return null;
        }
        Info info_ = new Info();
        if (info_.getVendorExtensions() != null && (map = this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions())) != null) {
            info_.getVendorExtensions().putAll(map);
        }
        info_.setTermsOfService(from.getTermsOfServiceUrl());
        info_.setLicense(this.licenseMapper.apiInfoToLicense(from));
        info_.setContact(this.map(from.getContact()));
        info_.setDescription(from.getDescription());
        info_.setVersion(from.getVersion());
        info_.setTitle(from.getTitle());
        return info_;
    }

    @Override
    protected Contact map(springfox.documentation.service.Contact from) {
        if (from == null) {
            return null;
        }
        Contact contact_ = new Contact();
        contact_.setName(from.getName());
        contact_.setUrl(from.getUrl());
        contact_.setEmail(from.getEmail());
        return contact_;
    }

    @Override
    protected io.swagger.models.Operation mapOperation(Operation from) {
        List<Parameter> list__;
        Set set__;
        Map<String, Response> map_;
        List<Scheme> list;
        if (from == null) {
            return null;
        }
        io.swagger.models.Operation operation = new io.swagger.models.Operation();
        Map<String, Object> map = this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions());
        if (map != null) {
            operation.setVendorExtensions(map);
        }
        if ((list = this.stringSetToSchemeList(from.getProtocol())) != null) {
            operation.setSchemes(list);
        }
        operation.setDescription(from.getNotes());
        List<Map<String, List<String>>> list_ = this.mapAuthorizations(from.getSecurityReferences());
        if (list_ != null) {
            operation.setSecurity(list_);
        }
        if ((map_ = this.mapResponseMessages(from.getResponseMessages())) != null) {
            operation.setResponses(map_);
        }
        operation.setOperationId(from.getUniqueId());
        Set set = from.getTags();
        if (set != null) {
            operation.setTags(new ArrayList(set));
        }
        operation.setSummary(from.getSummary());
        Set set_ = from.getConsumes();
        if (set_ != null) {
            operation.setConsumes(new ArrayList(set_));
        }
        if ((set__ = from.getProduces()) != null) {
            operation.setProduces(new ArrayList(set__));
        }
        if ((list__ = this.parameterListToParameterList(from.getParameters())) != null) {
            operation.setParameters(list__);
        }
        if (from.getDeprecated() != null) {
            operation.setDeprecated(Boolean.valueOf(Boolean.parseBoolean(from.getDeprecated())));
        }
        return operation;
    }

    @Override
    protected Tag mapTag(springfox.documentation.service.Tag from) {
        if (from == null) {
            return null;
        }
        Tag tag_ = new Tag();
        tag_.setName(from.getName());
        tag_.setDescription(from.getDescription());
        return tag_;
    }

    private ApiInfo fromResourceListingInfo(Documentation documentation) {
        if (documentation == null) {
            return null;
        }
        ResourceListing resourceListing = documentation.getResourceListing();
        if (resourceListing == null) {
            return null;
        }
        ApiInfo info = resourceListing.getInfo();
        if (info == null) {
            return null;
        }
        return info;
    }

    protected List<Tag> tagSetToTagList(Set<springfox.documentation.service.Tag> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (springfox.documentation.service.Tag tag : set) {
            list.add(this.mapTag(tag));
        }
        return list;
    }

    protected List<Scheme> stringSetToSchemeList(Set<String> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Scheme> list = new ArrayList<Scheme>();
        for (String string : set) {
            list.add(Enum.valueOf(Scheme.class, string));
        }
        return list;
    }

    protected List<Parameter> parameterListToParameterList(List<springfox.documentation.service.Parameter> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Parameter> list_ = new ArrayList<Parameter>();
        for (springfox.documentation.service.Parameter parameter : list) {
            list_.add(this.parameterMapper.mapParameter(parameter));
        }
        return list_;
    }
}

