/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.base;

import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springside.modules.utils.base.annotation.Nullable;

public class ExceptionUtil {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];

    public static RuntimeException unchecked(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UncheckedException(t);
    }

    public static Throwable unwrap(Throwable t) {
        if (t instanceof ExecutionException || t instanceof InvocationTargetException || t instanceof UncheckedException) {
            return t.getCause();
        }
        return t;
    }

    public static RuntimeException uncheckedAndWrap(Throwable t) {
        Throwable unwrapped = ExceptionUtil.unwrap(t);
        if (unwrapped instanceof RuntimeException) {
            throw (RuntimeException)unwrapped;
        }
        if (unwrapped instanceof Error) {
            throw (Error)unwrapped;
        }
        throw new UncheckedException(unwrapped);
    }

    public static String stackTraceText(Throwable t) {
        return Throwables.getStackTraceAsString((Throwable)t);
    }

    public static Throwable getRootCause(Throwable t) {
        return Throwables.getRootCause((Throwable)t);
    }

    public static boolean isCausedBy(Throwable t, Class<? extends Exception> ... causeExceptionClasses) {
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            for (Class<? extends Exception> causeClass : causeExceptionClasses) {
                if (!causeClass.isInstance(cause)) continue;
                return true;
            }
        }
        return false;
    }

    public static String toStringWithShortName(@Nullable Throwable t) {
        return ExceptionUtils.getMessage((Throwable)t);
    }

    public static String toStringWithRootCause(@Nullable Throwable t) {
        if (t == null) {
            return "";
        }
        String clsName = ClassUtils.getShortClassName((Object)t, null);
        String message = StringUtils.defaultString((String)t.getMessage());
        Throwable cause = ExceptionUtil.getRootCause(t);
        StringBuilder sb = new StringBuilder(128).append(clsName).append(": ").append(message);
        if (cause != t) {
            sb.append("; <---").append(ExceptionUtil.toStringWithShortName(cause));
        }
        return sb.toString();
    }

    public static <T extends Throwable> T setStackTrace(T exception, Class<?> throwClass, String throwClazz) {
        exception.setStackTrace(new StackTraceElement[]{new StackTraceElement(throwClass.getName(), throwClazz, null, -1)});
        return exception;
    }

    public static <T extends Throwable> T clearStackTrace(T exception) {
        for (Object cause = exception; cause != null; cause = cause.getCause()) {
            cause.setStackTrace(EMPTY_STACK_TRACE);
        }
        return exception;
    }

    public static class UncheckedException
    extends RuntimeException {
        private static final long serialVersionUID = 4140223302171577501L;

        public UncheckedException(Throwable cause) {
            super(cause);
        }

        @Override
        public String getMessage() {
            return super.getCause().getMessage();
        }
    }

    public static class CloneableRuntimeException
    extends RuntimeException
    implements Cloneable {
        private static final long serialVersionUID = 3984796576627959400L;
        protected String message;

        public CloneableRuntimeException() {
            super((Throwable)null);
        }

        public CloneableRuntimeException(String message) {
            super((Throwable)null);
            this.message = message;
        }

        public CloneableRuntimeException(String message, Throwable cause) {
            super(cause);
            this.message = message;
        }

        public CloneableRuntimeException clone() {
            try {
                return (CloneableRuntimeException)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public CloneableRuntimeException clone(String message) {
            CloneableRuntimeException newException = this.clone();
            newException.setMessage(message);
            return newException;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CloneableRuntimeException setStackTrace(Class<?> throwClazz, String throwMethod) {
            ExceptionUtil.setStackTrace(this, throwClazz, throwMethod);
            return this;
        }
    }

    public static class CloneableException
    extends Exception
    implements Cloneable {
        private static final long serialVersionUID = -6270471689928560417L;
        protected String message;

        public CloneableException() {
            super((Throwable)null);
        }

        public CloneableException(String message) {
            super((Throwable)null);
            this.message = message;
        }

        public CloneableException(String message, Throwable cause) {
            super(cause);
            this.message = message;
        }

        public CloneableException clone() {
            try {
                return (CloneableException)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public CloneableException clone(String message) {
            CloneableException newException = this.clone();
            newException.setMessage(message);
            return newException;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CloneableException setStackTrace(Class<?> throwClazz, String throwMethod) {
            ExceptionUtil.setStackTrace(this, throwClazz, throwMethod);
            return this;
        }
    }
}

