/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.collection;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.MapDifference;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.util.concurrent.AtomicLongMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.springside.modules.utils.base.Platforms;
import org.springside.modules.utils.base.annotation.NotNull;
import org.springside.modules.utils.base.annotation.Nullable;
import org.springside.modules.utils.collection.type.primitive.IntObjectHashMap;
import org.springside.modules.utils.collection.type.primitive.LongObjectHashMap;
import org.springside.modules.utils.concurrent.jsr166e.ConcurrentHashMapV8;

public class MapUtil {
    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static <K, V> V putIfAbsentWithFinalValue(@NotNull ConcurrentMap<K, V> map, K key, V value) {
        V result = map.putIfAbsent(key, value);
        return result != null ? result : value;
    }

    public static <K, V> V createIfAbsent(@NotNull ConcurrentMap<K, V> map, K key, @NotNull ValueCreator<? extends V> creator) {
        Object value = map.get(key);
        if (value == null) {
            return MapUtil.putIfAbsentWithFinalValue(map, key, creator.get());
        }
        return value;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMapWithCapacity(int expectedSize, float loadFactor) {
        int finalSize = (int)((double)expectedSize / (double)loadFactor + 1.0);
        return new HashMap(finalSize, loadFactor);
    }

    public static <K, V> HashMap<K, V> newHashMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(@NotNull K[] keys, @NotNull V[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys.length is " + keys.length + " but values.length is " + values.length);
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(@NotNull List<K> keys, @NotNull List<V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("keys.size is " + keys.size() + " but values.size is " + values.size());
        }
        HashMap<K, V> map = new HashMap<K, V>();
        Iterator<K> keyIt = keys.iterator();
        Iterator<V> valueIt = values.iterator();
        while (keyIt.hasNext()) {
            map.put(keyIt.next(), valueIt.next());
        }
        return map;
    }

    public static <K extends Comparable, V> TreeMap<K, V> newSortedMap() {
        return new TreeMap();
    }

    public static <C, K extends C, V> TreeMap<K, V> newSortedMap(@Nullable Comparator<C> comparator) {
        return Maps.newTreeMap(comparator);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(@NotNull Class<K> type) {
        return new EnumMap((Class)Preconditions.checkNotNull(type));
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap() {
        if (Platforms.IS_ATLEASET_JAVA8) {
            return new ConcurrentHashMap();
        }
        return new ConcurrentHashMapV8();
    }

    public static <K, V> ConcurrentSkipListMap<K, V> newConcurrentSortedMap() {
        return new ConcurrentSkipListMap();
    }

    public static <K, V> ConcurrentMap<K, V> createWeakKeyConcurrentHashMap(int initialCapacity, int concurrencyLevel) {
        return new MapMaker().weakKeys().initialCapacity(initialCapacity).concurrencyLevel(concurrencyLevel).makeMap();
    }

    public static <K, V> ConcurrentMap<K, V> createWeakValueConcurrentHashMap(int initialCapacity, int concurrencyLevel) {
        return new MapMaker().weakValues().initialCapacity(initialCapacity).concurrencyLevel(concurrencyLevel).makeMap();
    }

    public static <V> IntObjectHashMap<V> createIntObjectHashMap(int initialCapacity, float loadFactor) {
        return new IntObjectHashMap(initialCapacity, loadFactor);
    }

    public static <V> LongObjectHashMap<V> createLongObjectHashMap(int initialCapacity, float loadFactor) {
        return new LongObjectHashMap(initialCapacity, loadFactor);
    }

    public static <K> HashMap<K, MutableInt> createMutableIntValueHashMap(int initialCapacity, float loadFactor) {
        return new HashMap(initialCapacity, loadFactor);
    }

    public static <K> HashMap<K, MutableLong> createMutableLongValueHashMap(int initialCapacity, float loadFactor) {
        return new HashMap(initialCapacity, loadFactor);
    }

    public static <E> AtomicLongMap<E> createConcurrentMapCounter() {
        return AtomicLongMap.create();
    }

    public static <E> ConcurrentHashMultiset<E> createConcurrentMapCounter(Iterable<? extends E> elements) {
        return ConcurrentHashMultiset.create(elements);
    }

    public static <K, V> ArrayListMultimap<K, V> createListValueMap(int expectedKeys, int expectedValuesPerKey) {
        return ArrayListMultimap.create((int)expectedKeys, (int)expectedValuesPerKey);
    }

    public static <K, V extends Comparable> SortedSetMultimap<K, V> createSortedSetValueMap() {
        return MultimapBuilder.hashKeys().treeSetValues().build();
    }

    public static <K, V> SortedSetMultimap<K, V> createSortedSetValueMap(Comparator<V> comparator) {
        return (SortedSetMultimap)MultimapBuilder.hashKeys().treeSetValues(comparator);
    }

    public static <K extends Comparable, V> TreeRangeMap<K, V> createRangeMap() {
        return TreeRangeMap.create();
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return Collections.EMPTY_MAP;
    }

    public static <K, V> Map<K, V> emptyMapIfNull(Map<K, V> map) {
        return map == null ? Collections.EMPTY_MAP : map;
    }

    public static <K, V> Map<K, V> singletonMap(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> m) {
        return Collections.unmodifiableMap(m);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> m) {
        return Collections.unmodifiableSortedMap(m);
    }

    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        return Maps.difference(left, right);
    }

    public static interface ValueCreator<T> {
        public T get();
    }
}

