/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.concurrent;

import java.util.concurrent.TimeUnit;

public class ThreadUtil {
    public static void sleep(long durationMillis) {
        try {
            Thread.sleep(durationMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void sleep(long duration, TimeUnit unit) {
        try {
            Thread.sleep(unit.toMillis(duration));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void handleInterruptedException() {
        Thread.currentThread().interrupt();
    }

    public static String getCallerClass() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        if (stacktrace.length >= 4) {
            StackTraceElement element = stacktrace[3];
            return element.getClassName();
        }
        return "";
    }

    public static String getCallerMethod() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        if (stacktrace.length >= 4) {
            StackTraceElement element = stacktrace[3];
            return element.getClassName() + '.' + element.getMethodName() + "()";
        }
        return "";
    }

    public static String getCurrentClass() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        if (stacktrace.length >= 3) {
            StackTraceElement element = stacktrace[2];
            return element.getClassName();
        }
        return "";
    }

    public static String getCurrentMethod() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        if (stacktrace.length >= 3) {
            StackTraceElement element = stacktrace[2];
            return element.getClassName() + '.' + element.getMethodName() + "()";
        }
        return "";
    }
}

