/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.concurrent.threadpool;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.utils.base.annotation.NotNull;
import org.springside.modules.utils.base.annotation.Nullable;

public class ThreadPoolUtil {
    public static boolean gracefulShutdown(@Nullable ExecutorService threadPool, int shutdownTimeoutMills) {
        return threadPool != null ? MoreExecutors.shutdownAndAwaitTermination((ExecutorService)threadPool, (long)shutdownTimeoutMills, (TimeUnit)TimeUnit.MILLISECONDS) : true;
    }

    public static boolean gracefulShutdown(@Nullable ExecutorService threadPool, int shutdownTimeout, TimeUnit timeUnit) {
        return threadPool != null ? MoreExecutors.shutdownAndAwaitTermination((ExecutorService)threadPool, (long)shutdownTimeout, (TimeUnit)timeUnit) : true;
    }

    public static ThreadFactory buildThreadFactory(@NotNull String threadNamePrefix) {
        return new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d").build();
    }

    public static ThreadFactory buildThreadFactory(@NotNull String threadNamePrefix, @NotNull boolean daemon) {
        return new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d").setDaemon(daemon).build();
    }

    public static Runnable safeRunnable(@NotNull Runnable runnable) {
        return new SafeRunnable(runnable);
    }

    public static class SafeRunnable
    implements Runnable {
        private static Logger logger = LoggerFactory.getLogger(SafeRunnable.class);
        private Runnable runnable;

        public SafeRunnable(Runnable runnable) {
            Validate.notNull((Object)runnable);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable e) {
                logger.error("Unexpected error occurred in task", e);
            }
        }
    }
}

