/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.io;

import com.google.common.base.Predicate;
import com.google.common.collect.TreeTraverser;
import com.google.common.io.Files;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.springside.modules.utils.io.FilePathUtil;
import org.springside.modules.utils.io.FileUtil;
import org.springside.modules.utils.text.WildcardMatcher;

public class FileTreeWalker {
    public static List<File> listAll(File rootDir) {
        return Files.fileTreeTraverser().preOrderTraversal((Object)rootDir).toList();
    }

    public static List<File> listFile(File rootDir) {
        return Files.fileTreeTraverser().preOrderTraversal((Object)rootDir).filter(Files.isFile()).toList();
    }

    public static List<File> listFileWithExtension(File rootDir, String extension) {
        return Files.fileTreeTraverser().preOrderTraversal((Object)rootDir).filter((Predicate)new FileExtensionFilter(extension)).toList();
    }

    public static List<File> listFileWithWildcardFileName(File rootDir, String fileNamePattern) {
        return Files.fileTreeTraverser().preOrderTraversal((Object)rootDir).filter((Predicate)new WildcardFileNameFilter(fileNamePattern)).toList();
    }

    public static List<File> listFileWithRegexFileName(File rootDir, String regexFileNamePattern) {
        return Files.fileTreeTraverser().preOrderTraversal((Object)rootDir).filter((Predicate)new RegexFileNameFilter(regexFileNamePattern)).toList();
    }

    public static List<File> listFileWithAntPath(File rootDir, String antPathPattern) {
        return Files.fileTreeTraverser().preOrderTraversal((Object)rootDir).filter((Predicate)new AntPathFilter(FilePathUtil.contact(rootDir.getAbsolutePath(), antPathPattern))).toList();
    }

    public static TreeTraverser<File> fileTreeTraverser() {
        return Files.fileTreeTraverser();
    }

    public static final class AntPathFilter
    implements Predicate<File> {
        private final String pattern;

        private AntPathFilter(String pattern) {
            this.pattern = pattern;
        }

        public boolean apply(File input) {
            return input.isFile() && WildcardMatcher.matchPath(input.getAbsolutePath(), this.pattern);
        }
    }

    public static final class FileExtensionFilter
    implements Predicate<File> {
        private final String extension;

        private FileExtensionFilter(String extension) {
            this.extension = extension;
        }

        public boolean apply(File input) {
            return input.isFile() && this.extension.equals(FileUtil.getFileExtension(input));
        }
    }

    public static final class WildcardFileNameFilter
    implements Predicate<File> {
        private final String pattern;

        private WildcardFileNameFilter(String pattern) {
            this.pattern = pattern;
        }

        public boolean apply(File input) {
            return input.isFile() && WildcardMatcher.match(input.getName(), this.pattern);
        }
    }

    public static final class RegexFileNameFilter
    implements Predicate<File> {
        private final Pattern pattern;

        private RegexFileNameFilter(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        public boolean apply(File input) {
            return input.isFile() && this.pattern.matcher(input.getName()).matches();
        }
    }
}

