/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.utils.io.type.StringBuilderWriter;
import org.springside.modules.utils.text.Charsets;

public class IOUtil {
    private static final Logger logger = LoggerFactory.getLogger(IOUtil.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;
    private static final String CLOSE_ERROR_MESSAGE = "IOException thrown while closing Closeable.";

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.warn(CLOSE_ERROR_MESSAGE, (Throwable)e);
            }
        }
    }

    public static String toString(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, Charsets.UTF_8);
        return IOUtil.toString(reader);
    }

    public static String toString(Reader input) throws IOException {
        BufferedReader reader = IOUtil.toBufferedReader(input);
        StringBuilderWriter sw = new StringBuilderWriter();
        IOUtil.copy(reader, sw);
        return sw.toString();
    }

    public static List<String> toLines(InputStream input) throws IOException {
        return IOUtil.toLines(new InputStreamReader(input, Charsets.UTF_8));
    }

    public static List<String> toLines(Reader input) throws IOException {
        BufferedReader reader = IOUtil.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static void write(String data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data.getBytes(Charsets.UTF_8));
        }
    }

    public static void write(String data, Writer output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static long copy(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }
}

