/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.log;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.springside.modules.utils.time.ClockUtil;

public class ThrottledSlf4jLogger
implements Logger {
    private final Logger delegate;
    private final long windowSizeMillis;
    private final AtomicBoolean logToggle = new AtomicBoolean(false);
    private volatile long lastLoggedMillis = 0L;

    public ThrottledSlf4jLogger(Logger logger, long time, TimeUnit timeUnit) {
        this.delegate = logger;
        this.windowSizeMillis = timeUnit.toMillis(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldLog() {
        if (ClockUtil.currentTimeMillis() - this.lastLoggedMillis >= this.windowSizeMillis && this.logToggle.compareAndSet(false, true)) {
            try {
                this.lastLoggedMillis = ClockUtil.currentTimeMillis();
                boolean bl = true;
                return bl;
            }
            finally {
                this.logToggle.set(false);
            }
        }
        return false;
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.shouldLog()) {
            this.delegate.debug(msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.shouldLog()) {
            this.delegate.debug(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.delegate.debug(format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.shouldLog()) {
            this.delegate.debug(format, args);
        }
    }

    public void debug(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.delegate.debug(message, throwable);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        if (this.shouldLog()) {
            this.delegate.debug(marker, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.shouldLog()) {
            this.delegate.debug(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.delegate.debug(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.shouldLog()) {
            this.delegate.debug(marker, format, arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.shouldLog()) {
            this.delegate.debug(marker, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.shouldLog()) {
            this.delegate.debug(msg);
        }
    }

    public void info(String format, Object arg) {
        if (this.shouldLog()) {
            this.delegate.info(format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.delegate.info(format, arg1, arg2);
        }
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.shouldLog()) {
            this.delegate.warn(msg);
        }
    }

    public void warn(String format, Object arg) {
        if (this.shouldLog()) {
            this.delegate.warn(format, arg);
        }
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.shouldLog()) {
            this.delegate.error(msg);
        }
    }

    public void error(String format, Object arg) {
        if (this.shouldLog()) {
            this.delegate.error(format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.delegate.error(format, arg1, arg2);
        }
    }

    public void info(String format, Object ... args) {
        if (this.shouldLog()) {
            this.delegate.info(format, args);
        }
    }

    public void info(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.delegate.info(message, throwable);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        if (this.shouldLog()) {
            this.delegate.info(marker, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.shouldLog()) {
            this.delegate.info(marker, format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.delegate.info(marker, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.shouldLog()) {
            this.delegate.info(marker, format, arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.shouldLog()) {
            this.delegate.info(marker, msg, t);
        }
    }

    public void warn(String format, Object ... args) {
        if (this.shouldLog()) {
            this.delegate.warn(format, args);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.delegate.warn(format, arg1, arg2);
        }
    }

    public void warn(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.delegate.warn(message, throwable);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        if (this.shouldLog()) {
            this.delegate.warn(marker, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.shouldLog()) {
            this.delegate.warn(marker, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.delegate.warn(marker, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.shouldLog()) {
            this.delegate.warn(marker, format, arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.shouldLog()) {
            this.delegate.warn(marker, msg, t);
        }
    }

    public void error(String format, Object ... args) {
        if (this.shouldLog()) {
            this.delegate.error(format, args);
        }
    }

    public void error(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.delegate.error(message, throwable);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        if (this.shouldLog()) {
            this.delegate.error(marker, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.shouldLog()) {
            this.delegate.error(marker, format, arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.delegate.error(marker, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.shouldLog()) {
            this.delegate.error(marker, format, arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.shouldLog()) {
            this.delegate.error(marker, msg, t);
        }
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.shouldLog()) {
            this.delegate.trace(msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.shouldLog()) {
            this.delegate.trace(format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.delegate.trace(format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.shouldLog()) {
            this.delegate.trace(format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.shouldLog()) {
            this.delegate.trace(msg, t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        if (this.shouldLog()) {
            this.delegate.trace(marker, msg);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.shouldLog()) {
            this.delegate.trace(marker, format, arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.delegate.trace(marker, format, arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.shouldLog()) {
            this.delegate.trace(marker, format, argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.shouldLog()) {
            this.delegate.trace(marker, msg, t);
        }
    }
}

