/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.net;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.springside.modules.utils.number.NumberUtil;
import org.springside.modules.utils.text.MoreStringUtil;

public class IPUtil {
    public static int toInt(InetAddress address) {
        return InetAddresses.coerceToInteger((InetAddress)address);
    }

    public static String toString(InetAddress address) {
        return InetAddresses.toAddrString((InetAddress)address);
    }

    public static Inet4Address fromInt(int address) {
        return InetAddresses.fromInteger((int)address);
    }

    public static InetAddress fromIpString(String address) {
        return InetAddresses.forString((String)address);
    }

    public static Inet4Address fromIpv4String(String address) {
        byte[] bytes = IPUtil.ip4StringToBytes(address);
        if (bytes == null) {
            return null;
        }
        try {
            return (Inet4Address)Inet4Address.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String intToIpv4String(int i) {
        return new StringBuilder(15).append(i >> 24 & 0xFF).append('.').append(i >> 16 & 0xFF).append('.').append(i >> 8 & 0xFF).append('.').append(i & 0xFF).toString();
    }

    public static int ipv4StringToInt(String ipv4Str) {
        byte[] byteAddress = IPUtil.ip4StringToBytes(ipv4Str);
        if (byteAddress == null) {
            return 0;
        }
        return NumberUtil.toInt(byteAddress);
    }

    private static byte[] ip4StringToBytes(String ipv4Str) {
        if (ipv4Str == null) {
            return null;
        }
        List<String> it = MoreStringUtil.split(ipv4Str, '.', 4);
        if (it.size() != 4) {
            return null;
        }
        byte[] byteAddress = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int tempInt = Integer.parseInt(it.get(i));
            if (tempInt > 255) {
                return null;
            }
            byteAddress[i] = (byte)tempInt;
        }
        return byteAddress;
    }
}

