/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.reflect;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentMap;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.springside.modules.utils.base.ExceptionUtil;
import org.springside.modules.utils.collection.MapUtil;
import org.springside.modules.utils.reflect.ClassUtil;

public class FastMethodInvoker {
    private static ConcurrentMap<Class<?>, FastClass> fastClassMap = MapUtil.newConcurrentHashMap();
    private final FastMethod fastMethod;

    protected FastMethodInvoker(FastMethod fastMethod) {
        this.fastMethod = fastMethod;
    }

    public static FastMethodInvoker create(Class<?> clz, String methodName, Class<?> ... parameterTypes) {
        Method method = ClassUtil.getAccessibleMethod(clz, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + clz + ']');
        }
        return FastMethodInvoker.build(clz, method);
    }

    public static FastMethodInvoker createGetter(Class<?> clz, String propertyName) {
        Method method = ClassUtil.getGetterMethod(clz, propertyName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + clz + ']');
        }
        return FastMethodInvoker.build(clz, method);
    }

    public static FastMethodInvoker createSetter(Class<?> clz, String propertyName, Class<?> parameterType) {
        Method method = ClassUtil.getSetterMethod(clz, propertyName, parameterType);
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + clz + ']');
        }
        return FastMethodInvoker.build(clz, method);
    }

    private static FastMethodInvoker build(final Class<?> clz, Method method) {
        FastClass fastClz = MapUtil.createIfAbsent(fastClassMap, clz, new MapUtil.ValueCreator<FastClass>(){

            @Override
            public FastClass get() {
                return FastClass.create((Class)clz);
            }
        });
        return new FastMethodInvoker(fastClz.getMethod(method));
    }

    public <T> T invoke(Object obj, Object ... args) {
        try {
            return (T)this.fastMethod.invoke(obj, args);
        }
        catch (Exception e) {
            throw ExceptionUtil.uncheckedAndWrap(e);
        }
    }
}

