/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.reflect;

import java.lang.reflect.Method;
import org.springside.modules.utils.base.ExceptionUtil;
import org.springside.modules.utils.reflect.ClassUtil;

public class MethodInvoker {
    private final Method method;

    public static MethodInvoker createMethod(Class<?> clz, String methodName, Class<?> ... parameterTypes) {
        Method method = ClassUtil.getAccessibleMethod(clz, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + clz + ']');
        }
        return new MethodInvoker(method);
    }

    public static MethodInvoker createGetter(Class<?> clz, String propertyName) {
        Method method = ClassUtil.getGetterMethod(clz, propertyName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + clz + ']');
        }
        return new MethodInvoker(method);
    }

    public static MethodInvoker createSetter(Class<?> clz, String propertyName, Class<?> parameterType) {
        Method method = ClassUtil.getSetterMethod(clz, propertyName, parameterType);
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + clz + ']');
        }
        return new MethodInvoker(method);
    }

    protected MethodInvoker(Method method) {
        this.method = method;
    }

    public <T> T invoke(Object obj, Object ... args) {
        try {
            return (T)this.method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ExceptionUtil.uncheckedAndWrap(e);
        }
    }
}

