/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.time;

import java.util.Date;

public class ClockUtil {
    private static Clock INSTANCE = new DefaultClock();

    public static long elapsedTime(long beginTime) {
        return ClockUtil.currentTimeMillis() - beginTime;
    }

    public static synchronized DummyClock useDummyClock() {
        INSTANCE = new DummyClock();
        return (DummyClock)INSTANCE;
    }

    public static synchronized DummyClock useDummyClock(long timeStampMills) {
        INSTANCE = new DummyClock(timeStampMills);
        return (DummyClock)INSTANCE;
    }

    public static synchronized DummyClock useDummyClock(Date date) {
        INSTANCE = new DummyClock(date);
        return (DummyClock)INSTANCE;
    }

    public static synchronized void useDefaultClock() {
        INSTANCE = new DefaultClock();
    }

    public static Date currentDate() {
        return INSTANCE.currentDate();
    }

    public static long currentTimeMillis() {
        return INSTANCE.currentTimeMillis();
    }

    public static long nanoTime() {
        return INSTANCE.nanoTime();
    }

    public static class DummyClock
    implements Clock {
        private long time;
        private long nanoTme;

        public DummyClock() {
            this(System.currentTimeMillis());
        }

        public DummyClock(Date date) {
            this(date.getTime());
        }

        public DummyClock(long time) {
            this.time = time;
            this.nanoTme = System.nanoTime();
        }

        @Override
        public Date currentDate() {
            return new Date(this.time);
        }

        @Override
        public long currentTimeMillis() {
            return this.time;
        }

        @Override
        public long nanoTime() {
            return this.nanoTme;
        }

        public void updateNow(Date newDate) {
            this.time = newDate.getTime();
        }

        public void updateNow(long newTime) {
            this.time = newTime;
        }

        public void increaseTime(int millis) {
            this.time += (long)millis;
        }

        public void decreaseTime(int millis) {
            this.time -= (long)millis;
        }

        public void setNanoTime(long nanoTime) {
            this.nanoTme = nanoTime;
        }
    }

    public static class DefaultClock
    implements Clock {
        @Override
        public Date currentDate() {
            return new Date();
        }

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }
    }

    public static interface Clock {
        public Date currentDate();

        public long currentTimeMillis();

        public long nanoTime();
    }
}

