/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.util.PrimitiveType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Type typeFromString(String type) {
        PrimitiveType primitive = PrimitiveType.fromName(type);
        if (primitive != null) {
            return primitive.getKeyClass();
        }
        try {
            return ReflectionUtils.loadClassByName(type);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to resolve '%s' into class", type), (Throwable)e);
            return null;
        }
    }

    public static Class<?> loadClassByName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
    }

    public static boolean isOverriddenMethod(Method methodToFind, Class<?> cls) {
        Class<?> superClass = cls.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            for (Method method : superClass.getMethods()) {
                if (!method.getName().equals(methodToFind.getName()) || !method.getReturnType().isAssignableFrom(methodToFind.getReturnType()) || !Arrays.equals(method.getParameterTypes(), methodToFind.getParameterTypes()) || Arrays.equals(method.getGenericParameterTypes(), methodToFind.getGenericParameterTypes())) continue;
                return true;
            }
            return ReflectionUtils.isOverriddenMethod(methodToFind, superClass);
        }
        return false;
    }

    public static Method getOverriddenMethod(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Class<?> superClass = declaringClass.getSuperclass();
        Method result = null;
        if (superClass != null && !superClass.equals(Object.class)) {
            result = ReflectionUtils.findMethod(method, superClass);
        }
        if (result == null) {
            for (Class<?> anInterface : declaringClass.getInterfaces()) {
                result = ReflectionUtils.findMethod(method, anInterface);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public static Method findMethod(Method methodToFind, Class<?> cls) {
        String methodToSearch = methodToFind.getName();
        Class<?>[] soughtForParameterType = methodToFind.getParameterTypes();
        Type[] soughtForGenericParameterType = methodToFind.getGenericParameterTypes();
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodToSearch) || !method.getReturnType().isAssignableFrom(methodToFind.getReturnType())) continue;
            Class<?>[] srcParameterTypes = method.getParameterTypes();
            Type[] srcGenericParameterTypes = method.getGenericParameterTypes();
            if (soughtForParameterType.length != srcParameterTypes.length || soughtForGenericParameterType.length != srcGenericParameterTypes.length || !ReflectionUtils.hasIdenticalParameters(srcParameterTypes, soughtForParameterType, srcGenericParameterTypes, soughtForGenericParameterType)) continue;
            return method;
        }
        return null;
    }

    private static boolean hasIdenticalParameters(Class<?>[] srcParameterTypes, Class<?>[] soughtForParameterType, Type[] srcGenericParameterTypes, Type[] soughtForGenericParameterType) {
        for (int j = 0; j < soughtForParameterType.length; ++j) {
            Class<?> parameterType = soughtForParameterType[j];
            if (srcParameterTypes[j].equals(parameterType) || !srcGenericParameterTypes[j].equals(soughtForGenericParameterType[j]) && srcParameterTypes[j].isAssignableFrom(parameterType)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInject(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!"javax.inject.Inject".equals(annotation.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isConstructorCompatible(Constructor<?> constructor) {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            int access = 7;
            return constructor.getParameterTypes().length == 0 && (constructor.getDeclaringClass().getModifiers() & 7) == constructor.getModifiers();
        }
        return true;
    }

    public static List<Field> getDeclaredFields(Class<?> cls) {
        if (cls == null || Object.class.equals(cls)) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Field field : cls.getDeclaredFields()) {
            fields.add(field);
            fieldNames.add(field.getName());
        }
        for (Field field : ReflectionUtils.getDeclaredFields(cls.getSuperclass())) {
            if (fieldNames.contains(field.getName())) continue;
            fields.add(field);
        }
        return fields;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationClass) {
        Method superclassMethod;
        A annotation = method.getAnnotation(annotationClass);
        if (annotation == null && (superclassMethod = ReflectionUtils.getOverriddenMethod(method)) != null) {
            annotation = ReflectionUtils.getAnnotation(superclassMethod, annotationClass);
        }
        return annotation;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> cls, Class<A> annotationClass) {
        Class<?> superClass;
        A annotation = cls.getAnnotation(annotationClass);
        if (annotation == null && (superClass = cls.getSuperclass()) != null && !superClass.equals(Object.class)) {
            annotation = ReflectionUtils.getAnnotation(superClass, annotationClass);
        }
        if (annotation == null) {
            for (Class<?> anInterface : cls.getInterfaces()) {
                annotation = ReflectionUtils.getAnnotation(anInterface, annotationClass);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return annotation;
    }

    public static Annotation[][] getParameterAnnotations(Method method) {
        Annotation[][] methodAnnotations = method.getParameterAnnotations();
        Method overriddenmethod = ReflectionUtils.getOverriddenMethod(method);
        if (overriddenmethod != null) {
            Annotation[][] overriddenAnnotations = overriddenmethod.getParameterAnnotations();
            for (int i = 0; i < methodAnnotations.length; ++i) {
                int j;
                ArrayList<Class<? extends Annotation>> types = new ArrayList<Class<? extends Annotation>>();
                for (j = 0; j < methodAnnotations[i].length; ++j) {
                    types.add(methodAnnotations[i][j].annotationType());
                }
                for (j = 0; j < overriddenAnnotations[i].length; ++j) {
                    if (types.contains(overriddenAnnotations[i][j].annotationType())) continue;
                    methodAnnotations[i] = (Annotation[])ArrayUtils.add((Object[])methodAnnotations[i], (Object)overriddenAnnotations[i][j]);
                }
            }
        }
        return methodAnnotations;
    }

    public static boolean isVoid(Type type) {
        Class cls = TypeFactory.defaultInstance().constructType(type).getRawClass();
        return Void.class.isAssignableFrom(cls) || Void.TYPE.isAssignableFrom(cls);
    }
}

