/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.source;

import com.google.common.io.ByteStreams;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.FileMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileEntry
implements Entry {
    private final String name;
    private final File file;

    public FileEntry(String name, File file) {
        this.name = name;
        this.file = file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public void writeEntry(OutputStream outputStream) throws IOException {
        if (this.file.isDirectory()) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream entryInputStream = this.getInputStream();){
            ByteStreams.copy((InputStream)entryInputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getFileMode() {
        return FileMode.getFileMode(this.file);
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isExecutable() {
        return FileMode.EXECUTABLE_FILE.equals(this.getFileMode());
    }

    @Override
    public long getTime() {
        return this.file.lastModified();
    }
}

