/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.perms;

import io.tesla.proviso.archive.perms.PermissionsSet;
import io.tesla.proviso.archive.perms.PosixModes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public final class ModeParser {
    private static final Pattern COMMA = Pattern.compile(",");

    private ModeParser() {
        throw new Error("nice try!");
    }

    public static PermissionsSet buildPermissionsSet(String instructions) {
        Objects.requireNonNull(instructions);
        EnumSet<PosixFilePermission> toAdd = EnumSet.noneOf(PosixFilePermission.class);
        EnumSet<PosixFilePermission> toRemove = EnumSet.noneOf(PosixFilePermission.class);
        ModeParser.parse(instructions, toAdd, toRemove);
        return new PermissionsSet(toAdd, toRemove);
    }

    static void parse(String instructions, Set<PosixFilePermission> toAdd, Set<PosixFilePermission> toRemove) {
        String[] stringArray = COMMA.split(instructions);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String instruction = stringArray[n2];
            ModeParser.parseOne(instruction, toAdd, toRemove);
            ++n2;
        }
    }

    static void parseOne(String instruction, Set<PosixFilePermission> toAdd, Set<PosixFilePermission> toRemove) {
        Set<PosixFilePermission> set;
        String what;
        String who;
        int plus = instruction.indexOf(43);
        int minus = instruction.indexOf(45);
        if (plus < 0 && minus < 0) {
            throw new RuntimeException("Invalid unix mode expresson: '" + instruction + "'");
        }
        if (plus >= 0) {
            who = plus == 0 ? "ugo" : instruction.substring(0, plus);
            what = instruction.substring(plus + 1);
            set = toAdd;
        } else {
            who = minus == 0 ? "ugo" : instruction.substring(0, minus);
            what = instruction.substring(minus + 1);
            set = toRemove;
        }
        if (what.isEmpty()) {
            throw new RuntimeException("Invalid unix mode expresson: '" + instruction + "'");
        }
        ModeParser.modifySet(who, what, set, instruction);
    }

    private static void modifySet(String who, String what, Set<PosixFilePermission> set, String instruction) {
        int whoLength = who.length();
        int whatLength = what.length();
        int i = 0;
        while (i < whoLength) {
            int whoOrdinal = 0;
            switch (who.charAt(i)) {
                case 'o': {
                    ++whoOrdinal;
                }
                case 'g': {
                    ++whoOrdinal;
                }
                case 'u': {
                    break;
                }
                case 'a': {
                    throw new UnsupportedOperationException(instruction);
                }
                default: {
                    throw new RuntimeException("Invalid unix mode expresson: '" + instruction + "'");
                }
            }
            int j = 0;
            while (j < whatLength) {
                int whatOrdinal = 3 * whoOrdinal;
                switch (what.charAt(j)) {
                    case 'x': {
                        ++whatOrdinal;
                    }
                    case 'w': {
                        ++whatOrdinal;
                    }
                    case 'r': {
                        break;
                    }
                    case 'X': {
                        throw new UnsupportedOperationException(instruction);
                    }
                    default: {
                        throw new RuntimeException("Invalid unix mode expresson: '" + instruction + "'");
                    }
                }
                set.add(PosixModes.PERMISSIONS[whatOrdinal]);
                ++j;
            }
            ++i;
        }
    }
}

