/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.tar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.tesla.proviso.archive.ArchiveHandlerSupport;
import io.tesla.proviso.archive.ExtendedArchiveEntry;
import io.tesla.proviso.archive.Selector;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.tar.ExtendedTarArchiveEntry;
import io.tesla.proviso.archive.tar.TarGzArchiveSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class TarGzArchiveHandler
extends ArchiveHandlerSupport {
    private final File archive;
    private final boolean posixLongFileMode;
    private final Map<String, ExtendedArchiveEntry> processedFilesNames;
    private final Selector hardLinkSelector;

    public TarGzArchiveHandler(File archive, boolean posixLongFileMode, List<String> hardLinkIncludes, List<String> hardLinkExcludes) {
        this.archive = archive;
        this.posixLongFileMode = posixLongFileMode;
        this.processedFilesNames = Maps.newLinkedHashMap();
        this.hardLinkSelector = hardLinkIncludes.size() > 0 || hardLinkExcludes.size() > 0 ? new Selector(hardLinkIncludes, hardLinkExcludes) : new Selector(null, (List<String>)ImmutableList.of((Object)"**/**"));
    }

    @Override
    public ExtendedArchiveEntry newEntry(String entryName, ExtendedArchiveEntry entry) {
        if (this.hardLinkSelector.include(entryName)) {
            ExtendedArchiveEntry sourceToHardLink = this.processedFilesNames.get(this.fileNameOf(entry));
            if (sourceToHardLink != null) {
                ExtendedTarArchiveEntry tarArchiveEntry = new ExtendedTarArchiveEntry(entryName, 49);
                tarArchiveEntry.setLinkName(sourceToHardLink.getName());
                return tarArchiveEntry;
            }
            this.processedFilesNames.put(this.fileNameOf(entry), entry);
        }
        ExtendedTarArchiveEntry tarArchiveEntry = new ExtendedTarArchiveEntry(entryName, entry);
        tarArchiveEntry.setSize(entry.getSize());
        return tarArchiveEntry;
    }

    @Override
    public ArchiveInputStream getInputStream() throws IOException {
        return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(this.archive)));
    }

    @Override
    public ArchiveOutputStream getOutputStream() throws IOException {
        TarArchiveOutputStream stream = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new FileOutputStream(this.archive)));
        if (this.posixLongFileMode) {
            stream.setLongFileMode(3);
        }
        return stream;
    }

    @Override
    public Source getArchiveSource() {
        return new TarGzArchiveSource(this.archive);
    }

    private String fileNameOf(ExtendedArchiveEntry entry) {
        return entry.getName().substring(entry.getName().lastIndexOf(47) + 1);
    }
}

