/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.zip;

import com.google.common.io.ByteStreams;
import io.tesla.proviso.archive.ExtendedArchiveEntry;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.perms.FileMode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipArchiveSource
implements Source {
    private ZipFile zipFile;
    private Enumeration<ZipArchiveEntry> entries;

    public ZipArchiveSource(File archive) {
        try {
            this.zipFile = new ZipFile(archive, "UTF8", true){

                protected void finalize() throws Throwable {
                    super.close();
                }
            };
            this.entries = this.zipFile.getEntries();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot determine the type of archive %s.", archive), e);
        }
    }

    @Override
    public Iterable<ExtendedArchiveEntry> entries() {
        return () -> new ArchiveEntryIterator();
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    class ArchiveEntryIterator
    implements Iterator<ExtendedArchiveEntry> {
        ArchiveEntryIterator() {
        }

        @Override
        public ExtendedArchiveEntry next() {
            return new EntrySourceArchiveEntry((ZipArchiveEntry)ZipArchiveSource.this.entries.nextElement());
        }

        @Override
        public boolean hasNext() {
            return ZipArchiveSource.this.entries.hasMoreElements();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove method not implemented");
        }
    }

    class EntrySourceArchiveEntry
    implements ExtendedArchiveEntry {
        final ZipArchiveEntry archiveEntry;

        public EntrySourceArchiveEntry(ZipArchiveEntry archiveEntry) {
            this.archiveEntry = archiveEntry;
        }

        public String getName() {
            return this.archiveEntry.getName();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return ZipArchiveSource.this.zipFile.getInputStream(this.archiveEntry);
        }

        @Override
        public boolean isHardLink() {
            return false;
        }

        @Override
        public String getHardLinkPath() {
            return null;
        }

        public long getSize() {
            return this.archiveEntry.getSize();
        }

        @Override
        public void writeEntry(OutputStream outputStream) throws IOException {
            ByteStreams.copy((InputStream)this.getInputStream(), (OutputStream)outputStream);
        }

        @Override
        public void setFileMode(int mode) {
        }

        @Override
        public int getFileMode() {
            return this.archiveEntry.getUnixMode();
        }

        @Override
        public void setSize(long size) {
        }

        @Override
        public void setTime(long time) {
        }

        public boolean isDirectory() {
            return this.archiveEntry.isDirectory();
        }

        public Date getLastModifiedDate() {
            return null;
        }

        @Override
        public boolean isExecutable() {
            return FileMode.EXECUTABLE_FILE.equals(this.getFileMode());
        }

        @Override
        public long getTime() {
            return this.archiveEntry.getTime();
        }
    }
}

