/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLSetOption;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLConnectionFactory;
import io.vertx.mysqlclient.impl.command.ChangeUserCommand;
import io.vertx.mysqlclient.impl.command.DebugCommand;
import io.vertx.mysqlclient.impl.command.InitDbCommand;
import io.vertx.mysqlclient.impl.command.PingCommand;
import io.vertx.mysqlclient.impl.command.ResetConnectionCommand;
import io.vertx.mysqlclient.impl.command.SetOptionCommand;
import io.vertx.mysqlclient.impl.command.StatisticsCommand;
import io.vertx.mysqlclient.spi.MySQLDriver;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;

public class MySQLConnectionImpl
extends SqlConnectionBase<MySQLConnectionImpl>
implements MySQLConnection {
    public static Future<MySQLConnection> connect(ContextInternal ctx, MySQLConnectOptions options) {
        MySQLConnectionFactory client;
        if (options.isUsingDomainSocket() && !ctx.owner().isNativeTransportEnabled()) {
            return ctx.failedFuture("Native transport is not available");
        }
        try {
            client = new MySQLConnectionFactory(ctx.owner(), options);
        }
        catch (Exception e) {
            return ctx.failedFuture((Throwable)e);
        }
        ctx.addCloseHook((Closeable)client);
        return client.connect((Context)ctx);
    }

    public MySQLConnectionImpl(ContextInternal context, ConnectionFactory factory, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(context, factory, conn, (Driver)MySQLDriver.INSTANCE, tracer, metrics);
    }

    @Override
    public MySQLConnection ping(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.ping();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> ping() {
        return this.schedule(this.context, new PingCommand());
    }

    @Override
    public MySQLConnection specifySchema(String schemaName, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.specifySchema(schemaName);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> specifySchema(String schemaName) {
        return this.schedule(this.context, new InitDbCommand(schemaName));
    }

    @Override
    public MySQLConnection getInternalStatistics(Handler<AsyncResult<String>> handler) {
        Future<String> fut = this.getInternalStatistics();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<String> getInternalStatistics() {
        return this.schedule(this.context, new StatisticsCommand());
    }

    @Override
    public MySQLConnection setOption(MySQLSetOption option, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.setOption(option);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> setOption(MySQLSetOption option) {
        return this.schedule(this.context, new SetOptionCommand(option));
    }

    @Override
    public MySQLConnection resetConnection(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.resetConnection();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> resetConnection() {
        return this.schedule(this.context, new ResetConnectionCommand());
    }

    @Override
    public MySQLConnection debug(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.debug();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> debug() {
        return this.schedule(this.context, new DebugCommand());
    }

    @Override
    public MySQLConnection changeUser(MySQLAuthOptions options, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.changeUser(options);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> changeUser(MySQLAuthOptions options) {
        String charset;
        MySQLCollation collation = options.getCollation() != null ? MySQLCollation.valueOfName(options.getCollation()) : ((charset = options.getCharset()) == null ? MySQLCollation.DEFAULT_COLLATION : MySQLCollation.valueOfName(MySQLCollation.getDefaultCollationFromCharsetName(charset)));
        Buffer serverRsaPublicKey = null;
        if (options.getServerRsaPublicKeyValue() != null) {
            serverRsaPublicKey = options.getServerRsaPublicKeyValue();
        } else if (options.getServerRsaPublicKeyPath() != null) {
            serverRsaPublicKey = this.context.owner().fileSystem().readFileBlocking(options.getServerRsaPublicKeyPath());
        }
        ChangeUserCommand cmd = new ChangeUserCommand(options.getUser(), options.getPassword(), options.getDatabase(), collation, serverRsaPublicKey, options.getProperties());
        return this.schedule(this.context, cmd);
    }
}

